/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.api;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.lime.api.Entry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EntryListType", propOrder={"entry"})
@CodingStyleguideUnaware
public class EntryListType
implements Serializable {
    @XmlElement(name="Entry")
    private List<Entry> entry;

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<Entry> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<Entry>();
        }
        return this.entry;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EntryListType entryListType = (EntryListType)object;
        return EqualsHelper.equals(this.entry, entryListType.entry);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.entry).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("entry", this.entry).toString();
    }

    public void setEntry(@Nullable List<Entry> list) {
        this.entry = list;
    }

    public boolean hasEntryEntries() {
        return !this.getEntry().isEmpty();
    }

    public boolean hasNoEntryEntries() {
        return this.getEntry().isEmpty();
    }

    @Nonnegative
    public int getEntryCount() {
        return this.getEntry().size();
    }

    @Nullable
    public Entry getEntryAtIndex(@Nonnegative int n) {
        return this.getEntry().get(n);
    }

    public void addEntry(@Nonnull Entry entry) {
        this.getEntry().add(entry);
    }
}

