/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.api;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.identifier.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.IParticipantIdentifier;
import com.helger.peppol.identifier.IProcessIdentifier;
import com.helger.peppol.identifier.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppol.identifier.participant.SimpleParticipantIdentifier;
import com.helger.peppol.identifier.process.SimpleProcessIdentifier;
import com.helger.peppol.lime.api.IMessageMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MessageMetadata
implements IMessageMetadata {
    private final String m_sMessageID;
    private final String m_sChannelID;
    private final SimpleParticipantIdentifier m_aSenderID;
    private final SimpleParticipantIdentifier m_aRecipientID;
    private final SimpleDocumentTypeIdentifier m_aDocumentTypeID;
    private final SimpleProcessIdentifier m_aProcessID;

    public MessageMetadata(@Nullable String string, @Nullable String string2, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier) {
        this.m_sMessageID = string;
        this.m_sChannelID = string2;
        this.m_aSenderID = new SimpleParticipantIdentifier(iParticipantIdentifier);
        this.m_aRecipientID = new SimpleParticipantIdentifier(iParticipantIdentifier2);
        this.m_aDocumentTypeID = new SimpleDocumentTypeIdentifier(iDocumentTypeIdentifier);
        this.m_aProcessID = new SimpleProcessIdentifier(iProcessIdentifier);
    }

    @Override
    @Nullable
    public String getMessageID() {
        return this.m_sMessageID;
    }

    @Override
    @Nullable
    public String getChannelID() {
        return this.m_sChannelID;
    }

    @Override
    @Nonnull
    public SimpleParticipantIdentifier getSenderID() {
        return this.m_aSenderID;
    }

    @Override
    @Nonnull
    public SimpleParticipantIdentifier getRecipientID() {
        return this.m_aRecipientID;
    }

    @Override
    @Nonnull
    public SimpleDocumentTypeIdentifier getDocumentTypeID() {
        return this.m_aDocumentTypeID;
    }

    @Override
    @Nonnull
    public SimpleProcessIdentifier getProcessID() {
        return this.m_aProcessID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MessageMetadata)) {
            return false;
        }
        MessageMetadata messageMetadata = (MessageMetadata)object;
        return EqualsHelper.equals((Object)this.m_sMessageID, (Object)messageMetadata.m_sMessageID) && EqualsHelper.equals((Object)this.m_sChannelID, (Object)messageMetadata.m_sChannelID) && this.m_aSenderID.equals((Object)messageMetadata.m_aSenderID) && this.m_aRecipientID.equals((Object)messageMetadata.m_aRecipientID) && this.m_aDocumentTypeID.equals((Object)messageMetadata.m_aDocumentTypeID) && this.m_aProcessID.equals((Object)messageMetadata.m_aProcessID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sMessageID).append((Object)this.m_sChannelID).append((Object)this.m_aSenderID).append((Object)this.m_aRecipientID).append((Object)this.m_aDocumentTypeID).append((Object)this.m_aProcessID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("messageID", (Object)this.m_sMessageID).append("channelID", (Object)this.m_sChannelID).append("senderID", (Object)this.m_aSenderID).append("recipientID", (Object)this.m_aRecipientID).append("documentID", (Object)this.m_aDocumentTypeID).append("processID", (Object)this.m_aProcessID).toString();
    }
}

