/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.api;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.string.StringHelper;
import com.helger.commons.xml.ChildElementIterator;
import com.helger.commons.xml.XMLFactory;
import com.helger.jaxb.JAXBContextCache;
import com.helger.peppol.identifier.DocumentIdentifierType;
import com.helger.peppol.identifier.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.IIdentifier;
import com.helger.peppol.identifier.IParticipantIdentifier;
import com.helger.peppol.identifier.IProcessIdentifier;
import com.helger.peppol.identifier.IdentifierHelper;
import com.helger.peppol.identifier.ObjectFactory;
import com.helger.peppol.identifier.ParticipantIdentifierType;
import com.helger.peppol.identifier.ProcessIdentifierType;
import com.helger.peppol.identifier.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppol.identifier.participant.SimpleParticipantIdentifier;
import com.helger.peppol.identifier.process.SimpleProcessIdentifier;
import com.helger.peppol.lime.api.CTransportIdentifiers;
import com.helger.peppol.lime.api.IMessageMetadata;
import com.helger.peppol.lime.api.MessageMetadata;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class MessageMetadataHelper {
    private static final QName QNAME_MESSAGEID = ObjectFactory._MessageIdentifier_QNAME;
    private static final QName QNAME_CHANNELID = ObjectFactory._ChannelIdentifier_QNAME;
    private static final QName QNAME_RECIPIENTID = ObjectFactory._RecipientIdentifier_QNAME;
    private static final QName QNAME_SENDERID = ObjectFactory._SenderIdentifier_QNAME;
    private static final QName QNAME_DOCUMENTID = ObjectFactory._DocumentIdentifier_QNAME;
    private static final QName QNAME_PROCESSID = ObjectFactory._ProcessIdentifier_QNAME;
    private static final QName QNAME_SCHEME = new QName(null, "scheme");

    private MessageMetadataHelper() {
    }

    @Nonnull
    public static String getDebugInfo(@Nonnull IMessageMetadata iMessageMetadata) {
        return "\tMessageID:\t" + iMessageMetadata.getMessageID() + "\n\tChannelID:\t" + iMessageMetadata.getChannelID() + "\n\tSenderID:\t" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)iMessageMetadata.getSenderID()) + "\n\tRecipientID:\t" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)iMessageMetadata.getRecipientID()) + "\n\tDocumentTypeID:\t" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)iMessageMetadata.getDocumentTypeID()) + "\n\tProcessID:\t" + IdentifierHelper.getIdentifierURIEncoded((IIdentifier)iMessageMetadata.getProcessID());
    }

    @Nonnull
    public static Document createHeadersDocument(@Nonnull IMessageMetadata iMessageMetadata) throws JAXBException {
        SimpleProcessIdentifier simpleProcessIdentifier;
        SimpleDocumentTypeIdentifier simpleDocumentTypeIdentifier;
        SimpleParticipantIdentifier simpleParticipantIdentifier;
        SimpleParticipantIdentifier simpleParticipantIdentifier2;
        String string;
        Marshaller marshaller;
        ObjectFactory objectFactory = new ObjectFactory();
        Document document = XMLFactory.newDocument();
        Element element = (Element)document.appendChild(document.createElementNS(CTransportIdentifiers.NAMESPACE_TRANSPORT_IDS, "Headers"));
        String string2 = iMessageMetadata.getMessageID();
        if (StringHelper.hasText((String)string2)) {
            marshaller = JAXBContext.newInstance((Class[])new Class[]{String.class}).createMarshaller();
            marshaller.marshal((Object)objectFactory.createMessageIdentifier(string2), (Node)element);
        }
        if (StringHelper.hasText((String)(string = iMessageMetadata.getChannelID()))) {
            marshaller = JAXBContext.newInstance((Class[])new Class[]{String.class}).createMarshaller();
            marshaller.marshal((Object)objectFactory.createChannelIdentifier(string), (Node)element);
        }
        if ((simpleParticipantIdentifier2 = iMessageMetadata.getSenderID()) != null) {
            marshaller = JAXBContextCache.getInstance().getFromCache(ParticipantIdentifierType.class).createMarshaller();
            marshaller.marshal((Object)objectFactory.createSenderIdentifier((ParticipantIdentifierType)simpleParticipantIdentifier2), (Node)element);
        }
        if ((simpleParticipantIdentifier = iMessageMetadata.getRecipientID()) != null) {
            marshaller = JAXBContextCache.getInstance().getFromCache(ParticipantIdentifierType.class).createMarshaller();
            marshaller.marshal((Object)objectFactory.createRecipientIdentifier((ParticipantIdentifierType)simpleParticipantIdentifier), (Node)element);
        }
        if ((simpleDocumentTypeIdentifier = iMessageMetadata.getDocumentTypeID()) != null) {
            marshaller = JAXBContextCache.getInstance().getFromCache(DocumentIdentifierType.class).createMarshaller();
            marshaller.marshal((Object)objectFactory.createDocumentIdentifier((DocumentIdentifierType)simpleDocumentTypeIdentifier), (Node)element);
        }
        if ((simpleProcessIdentifier = iMessageMetadata.getProcessID()) != null) {
            marshaller = JAXBContextCache.getInstance().getFromCache(ProcessIdentifierType.class).createMarshaller();
            marshaller.marshal((Object)objectFactory.createProcessIdentifier((ProcessIdentifierType)simpleProcessIdentifier), (Node)element);
        }
        return document;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Header> createHeadersFromMetadata(@Nonnull IMessageMetadata iMessageMetadata) throws JAXBException {
        Document document = MessageMetadataHelper.createHeadersDocument(iMessageMetadata);
        ArrayList<Header> arrayList = new ArrayList<Header>();
        for (Element element : new ChildElementIterator((Node)document.getDocumentElement())) {
            arrayList.add(Headers.create((Element)element));
        }
        return arrayList;
    }

    @Nullable
    public static String getStringContent(@Nullable Header header) {
        if (header == null) {
            return null;
        }
        String string = header.getStringContent();
        return StringHelper.hasNoText((String)string) ? null : string;
    }

    @Nullable
    public static String getMessageID(@Nonnull HeaderList headerList) {
        return MessageMetadataHelper.getStringContent(headerList.get(QNAME_MESSAGEID, false));
    }

    @Nullable
    public static String getChannelID(@Nonnull HeaderList headerList) {
        return MessageMetadataHelper.getStringContent(headerList.get(QNAME_CHANNELID, false));
    }

    @Nullable
    private static SimpleParticipantIdentifier _getParticipantID(@Nonnull HeaderList headerList, @Nonnull QName qName) {
        Header header = headerList.get(qName, false);
        return header == null ? null : new SimpleParticipantIdentifier(header.getAttribute(QNAME_SCHEME), header.getStringContent());
    }

    @Nullable
    public static SimpleParticipantIdentifier getSenderID(@Nonnull HeaderList headerList) {
        return MessageMetadataHelper._getParticipantID(headerList, QNAME_SENDERID);
    }

    @Nullable
    public static SimpleParticipantIdentifier getRecipientID(@Nonnull HeaderList headerList) {
        return MessageMetadataHelper._getParticipantID(headerList, QNAME_RECIPIENTID);
    }

    @Nullable
    public static SimpleDocumentTypeIdentifier getDocumentTypeID(@Nonnull HeaderList headerList) {
        Header header = headerList.get(QNAME_DOCUMENTID, false);
        return header == null ? null : new SimpleDocumentTypeIdentifier(header.getAttribute(QNAME_SCHEME), header.getStringContent());
    }

    @Nullable
    public static SimpleProcessIdentifier getProcessID(@Nonnull HeaderList headerList) {
        Header header = headerList.get(QNAME_PROCESSID, false);
        return header == null ? null : new SimpleProcessIdentifier(header.getAttribute(QNAME_SCHEME), header.getStringContent());
    }

    @Nonnull
    public static MessageMetadata createMetadataFromHeaders(@Nonnull HeaderList headerList) {
        return new MessageMetadata(MessageMetadataHelper.getMessageID(headerList), MessageMetadataHelper.getChannelID(headerList), (IParticipantIdentifier)MessageMetadataHelper.getSenderID(headerList), (IParticipantIdentifier)MessageMetadataHelper.getRecipientID(headerList), (IDocumentTypeIdentifier)MessageMetadataHelper.getDocumentTypeID(headerList), (IProcessIdentifier)MessageMetadataHelper.getProcessID(headerList));
    }

    @Nonnull
    public static MessageMetadata createMetadataFromHeadersWithCustomMessageID(@Nonnull HeaderList headerList, @Nullable String string) {
        return new MessageMetadata(string, MessageMetadataHelper.getChannelID(headerList), (IParticipantIdentifier)MessageMetadataHelper.getSenderID(headerList), (IParticipantIdentifier)MessageMetadataHelper.getRecipientID(headerList), (IDocumentTypeIdentifier)MessageMetadataHelper.getDocumentTypeID(headerList), (IProcessIdentifier)MessageMetadataHelper.getProcessID(headerList));
    }
}

