/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.api.cert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessPointX509TrustManager
implements X509TrustManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AccessPointX509TrustManager.class);
    private final Set<String> m_aCommonNames;
    private final X509Certificate m_aRootCertificate;

    public AccessPointX509TrustManager(@Nullable Set<String> set, @Nullable X509Certificate x509Certificate) {
        this.m_aRootCertificate = x509Certificate;
        this.m_aCommonNames = set;
        if (this.m_aCommonNames == null && s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("No accepted common names present!");
        }
    }

    @Override
    public void checkClientTrusted(@Nonnull @Nonempty X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Checking client certificates.");
        }
        this._check(x509CertificateArray);
    }

    @Override
    public void checkServerTrusted(@Nonnull @Nonempty X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Checking server certificates.");
        }
        this._check(x509CertificateArray);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])ArrayHelper.newArray((Object[])new X509Certificate[]{this.m_aRootCertificate});
    }

    private void _check(@Nonnull @Nonempty X509Certificate[] x509CertificateArray) throws CertificateException {
        this._checkPrincipal(x509CertificateArray);
    }

    private void _checkPrincipal(@Nonnull @Nonempty X509Certificate[] x509CertificateArray) throws CertificateException {
        ValueEnforcer.notEmpty((Object[])x509CertificateArray, (String)"Certificate chain");
        if (this.m_aCommonNames != null) {
            String[] stringArray;
            boolean bl = false;
            String string = x509CertificateArray[0].getSubjectX500Principal().toString();
            for (String string2 : stringArray = RegExHelper.getSplitToArray((CharSequence)string, (String)",")) {
                String string3 = StringHelper.getFromFirstExcl((String)string2, (String)"CN=");
                if (!this.m_aCommonNames.contains(string3)) continue;
                bl = true;
                s_aLogger.info("Accepted issuer: " + string3);
                break;
            }
            if (!bl) {
                s_aLogger.error("No accepted issuer: " + string);
                throw new CertificateException("Remote principal is not trusted");
            }
        }
    }
}

