/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.client.impl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.xml.XMLFactory;
import com.helger.jaxb.JAXBContextCache;
import com.helger.peppol.identifier.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.IParticipantIdentifier;
import com.helger.peppol.identifier.IProcessIdentifier;
import com.helger.peppol.lime.api.CTransportIdentifiers;
import com.helger.peppol.lime.api.Entry;
import com.helger.peppol.lime.api.MessageMetadata;
import com.helger.peppol.lime.api.MessageMetadataHelper;
import com.helger.peppol.lime.api.PageListType;
import com.helger.peppol.lime.api.wstransfer.GetResponse;
import com.helger.peppol.lime.api.wstransfer.Resource;
import com.helger.peppol.lime.client.IEndpointReference;
import com.helger.peppol.lime.client.IInbox;
import com.helger.peppol.lime.client.IMessage;
import com.helger.peppol.lime.client.IMessageReference;
import com.helger.peppol.lime.client.MessageException;
import com.helger.peppol.lime.client.impl.LimeHelper;
import com.helger.peppol.lime.client.impl.Message;
import com.helger.peppol.lime.client.impl.MessageReference;
import com.helger.peppol.lime.client.soapheader.SoapHeaderMapper;
import com.helger.peppol.lime.client.username.IUsernamePWCredentials;
import com.helger.peppol.utils.W3CEndpointReferenceHelper;
import com.sun.xml.ws.api.message.HeaderList;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Inbox
implements IInbox {
    private static final Logger s_aLogger = LoggerFactory.getLogger(Inbox.class);

    private static void _validateCredentialsObj(@Nonnull IUsernamePWCredentials iUsernamePWCredentials) throws MessageException {
        if (iUsernamePWCredentials == null) {
            throw new MessageException("Credentials can not be a null value");
        }
        if (StringHelper.hasNoTextAfterTrim((String)iUsernamePWCredentials.getUsername()) || StringHelper.hasNoTextAfterTrim((String)iUsernamePWCredentials.getPassword())) {
            throw new MessageException("Credentials are invalid, username=" + iUsernamePWCredentials.getUsername() + " password=" + iUsernamePWCredentials.getPassword());
        }
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    private static List<Element> _createChannelReferenceParameter(IEndpointReference iEndpointReference) {
        Document document = XMLFactory.newDocument();
        Element element = document.createElementNS(CTransportIdentifiers.NAMESPACE_TRANSPORT_IDS, "ChannelIdentifier");
        element.setTextContent(iEndpointReference.getChannelID());
        return CollectionHelper.newList((Object)element);
    }

    @Override
    public List<IMessageReference> getMessageList(IUsernamePWCredentials iUsernamePWCredentials, IEndpointReference iEndpointReference) throws MessageException {
        Inbox._validateCredentialsObj(iUsernamePWCredentials);
        try {
            boolean bl;
            List<Element> list = Inbox._createChannelReferenceParameter(iEndpointReference);
            ArrayList<IMessageReference> arrayList = new ArrayList<IMessageReference>();
            while (bl = Inbox._getSinglePage(iEndpointReference, list, iUsernamePWCredentials, arrayList)) {
            }
            return arrayList;
        }
        catch (Exception exception) {
            s_aLogger.warn("Failed to get message list", (Throwable)exception);
            throw new MessageException(exception);
        }
    }

    @Override
    public List<IMessageReference> getMessageListPage(IUsernamePWCredentials iUsernamePWCredentials, IEndpointReference iEndpointReference, int n) throws MessageException {
        Inbox._validateCredentialsObj(iUsernamePWCredentials);
        try {
            ArrayList<IMessageReference> arrayList = new ArrayList<IMessageReference>();
            Inbox._getSinglePage(iEndpointReference, null, iUsernamePWCredentials, arrayList);
            return arrayList;
        }
        catch (Exception exception) {
            throw new MessageException(exception);
        }
    }

    @Override
    public IMessage getMessage(IUsernamePWCredentials iUsernamePWCredentials, IMessageReference iMessageReference) throws MessageException {
        Inbox._validateCredentialsObj(iUsernamePWCredentials);
        try {
            Resource resource = LimeHelper.createServicePort(iMessageReference.getEndpointReference().getAddress(), iUsernamePWCredentials);
            SoapHeaderMapper.setupHandlerChain((BindingProvider)resource, iMessageReference.getEndpointReference().getChannelID(), iMessageReference.getMessageID(), null);
            GetResponse getResponse = resource.get(null);
            List<Object> list = getResponse.getAny();
            if (CollectionHelper.getSize(list) == 1) {
                Document document = ((Node)CollectionHelper.getFirstElement(list)).getOwnerDocument();
                Message message = new Message(iMessageReference.getMessageID());
                message.setDocument(document);
                Inbox._setMessageMetadata(resource, message);
                return message;
            }
            throw new MessageException("No message found with id: " + iMessageReference.getMessageID());
        }
        catch (Exception exception) {
            s_aLogger.warn("Inbox error: ", (Throwable)exception);
            throw new MessageException(exception);
        }
    }

    @Override
    public void deleteMessage(IUsernamePWCredentials iUsernamePWCredentials, IMessageReference iMessageReference) throws MessageException {
        Inbox._validateCredentialsObj(iUsernamePWCredentials);
        try {
            Resource resource = LimeHelper.createServicePort(iMessageReference.getEndpointReference().getAddress(), iUsernamePWCredentials);
            SoapHeaderMapper.setupHandlerChain((BindingProvider)resource, iMessageReference.getEndpointReference().getChannelID(), iMessageReference.getMessageID(), null);
            resource.delete(null);
        }
        catch (Exception exception) {
            throw new MessageException(exception);
        }
    }

    private static boolean _getSinglePage(@Nonnull IEndpointReference iEndpointReference, @Nullable List<Element> list, @Nonnull IUsernamePWCredentials iUsernamePWCredentials, @Nonnull List<IMessageReference> list2) throws JAXBException, DOMException, KeyManagementException, NoSuchAlgorithmException {
        Node node;
        Unmarshaller unmarshaller;
        PageListType pageListType;
        s_aLogger.info("Retrieving inbox messages");
        Resource resource = LimeHelper.createServicePort(iEndpointReference.getAddress(), iUsernamePWCredentials);
        SoapHeaderMapper.setupHandlerChain((BindingProvider)resource, null, null, list);
        GetResponse getResponse = resource.get(null);
        boolean bl = false;
        if (getResponse != null && CollectionHelper.getSize(getResponse.getAny()) == 1 && (pageListType = (PageListType)(unmarshaller = JAXBContextCache.getInstance().getFromCache(PageListType.class).createUnmarshaller()).unmarshal(node = (Node)CollectionHelper.getFirstElement(getResponse.getAny()), PageListType.class).getValue()) != null && pageListType.getEntryList() != null) {
            for (Entry entry : pageListType.getEntryList().getEntry()) {
                MessageReference messageReference = new MessageReference();
                messageReference.setEndpointReference(iEndpointReference);
                for (Element element : W3CEndpointReferenceHelper.getReferenceParameters((W3CEndpointReference)entry.getEndpointReference())) {
                    if (!"MessageIdentifier".equals(element.getLocalName())) continue;
                    messageReference.setMessageID(element.getTextContent());
                    break;
                }
                list2.add(messageReference);
            }
            if (pageListType.getNextPageIdentifier() != null && pageListType.getNextPageIdentifier().getEndpointReference() != null) {
                W3CEndpointReference w3CEndpointReference = pageListType.getNextPageIdentifier().getEndpointReference();
                iEndpointReference.setAddress(W3CEndpointReferenceHelper.getAddress((W3CEndpointReference)w3CEndpointReference));
                list.clear();
                list.addAll(W3CEndpointReferenceHelper.getReferenceParameters((W3CEndpointReference)w3CEndpointReference));
                bl = true;
            }
        }
        return bl;
    }

    private static void _setMessageMetadata(Resource resource, Message message) throws Exception {
        HeaderList headerList = (HeaderList)((BindingProvider)resource).getResponseContext().get("com.sun.xml.ws.api.message.HeaderList");
        MessageMetadata messageMetadata = MessageMetadataHelper.createMetadataFromHeaders(headerList);
        message.setSenderID((IParticipantIdentifier)messageMetadata.getSenderID());
        message.setReceiverID((IParticipantIdentifier)messageMetadata.getRecipientID());
        message.setDocumentTypeID((IDocumentTypeIdentifier)messageMetadata.getDocumentTypeID());
        message.setProcessID((IProcessIdentifier)messageMetadata.getProcessID());
    }
}

