/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.client.impl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.random.VerySecureRandom;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.lime.api.cert.AccessPointX509TrustManager;
import com.helger.peppol.lime.api.wstransfer.Resource;
import com.helger.peppol.lime.client.username.IUsernamePWCredentials;
import com.helger.peppol.lime.client.ws.LimeClientService;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.ws.BindingProvider;

public final class LimeHelper {
    private LimeHelper() {
    }

    private static SSLSocketFactory _createSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagerArray = new TrustManager[]{new AccessPointX509TrustManager(null, null)};
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, trustManagerArray, VerySecureRandom.getInstance());
        return sSLContext.getSocketFactory();
    }

    private static HostnameVerifier _createHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return string.equals(sSLSession.getPeerHost());
            }
        };
        return hostnameVerifier;
    }

    @Nonnull
    public static Resource createServicePort(@Nonnull @Nonempty String string, @Nonnull IUsernamePWCredentials iUsernamePWCredentials) throws KeyManagementException, NoSuchAlgorithmException {
        HostnameVerifier hostnameVerifier;
        if (StringHelper.hasNoTextAfterTrim((String)string)) {
            throw new IllegalArgumentException("LIME access point url is empty");
        }
        LimeClientService limeClientService = new LimeClientService();
        Resource resource = limeClientService.getResourceBindingPort();
        BindingProvider bindingProvider = (BindingProvider)resource;
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.username", iUsernamePWCredentials.getUsername());
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.password", iUsernamePWCredentials.getPassword());
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", string);
        SSLSocketFactory sSLSocketFactory = LimeHelper._createSSLSocketFactory();
        if (sSLSocketFactory != null) {
            bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sSLSocketFactory);
            bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", sSLSocketFactory);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
        }
        if ((hostnameVerifier = LimeHelper._createHostnameVerifier()) != null) {
            bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.hostname.verifier", hostnameVerifier);
            bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", hostnameVerifier);
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        return resource;
    }
}

