/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.client.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.identifier.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.IParticipantIdentifier;
import com.helger.peppol.identifier.IProcessIdentifier;
import com.helger.peppol.lime.client.IMessage;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Document;

public class Message
implements IMessage {
    private final Date m_aCreatedTime;
    private final String m_sMessageID;
    private Document m_aDocument;
    private IParticipantIdentifier m_aSenderID;
    private IParticipantIdentifier m_aReceiverID;
    private IDocumentTypeIdentifier m_aDocumentTypeID;
    private IProcessIdentifier m_aProcessID;

    public Message() {
        this(UUID.randomUUID().toString());
    }

    public Message(@Nonnull @Nonempty String string) {
        this.m_sMessageID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        this.m_aCreatedTime = new Date();
    }

    @Override
    @Nonnull
    public Date getCreatedTime() {
        return this.m_aCreatedTime;
    }

    @Override
    @Nonnull
    public String getMessageID() {
        return this.m_sMessageID;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return this.m_aDocument;
    }

    @Override
    public void setDocument(@Nullable Document document) {
        this.m_aDocument = document;
    }

    @Override
    @Nullable
    public IParticipantIdentifier getSenderID() {
        return this.m_aSenderID;
    }

    @Override
    public void setSenderID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        this.m_aSenderID = iParticipantIdentifier;
    }

    @Override
    @Nullable
    public IParticipantIdentifier getReceiverID() {
        return this.m_aReceiverID;
    }

    @Override
    public void setReceiverID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        this.m_aReceiverID = iParticipantIdentifier;
    }

    @Override
    @Nullable
    public IDocumentTypeIdentifier getDocumentTypeID() {
        return this.m_aDocumentTypeID;
    }

    @Override
    public void setDocumentTypeID(@Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        this.m_aDocumentTypeID = iDocumentTypeIdentifier;
    }

    @Override
    @Nullable
    public IProcessIdentifier getProcessID() {
        return this.m_aProcessID;
    }

    @Override
    public void setProcessID(@Nullable IProcessIdentifier iProcessIdentifier) {
        this.m_aProcessID = iProcessIdentifier;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("CreatedTime", (Object)this.m_aCreatedTime).append("MessageID", (Object)this.m_sMessageID).append("Document", (Object)this.m_aDocument).append("SenderID", (Object)this.m_aSenderID).append("ReceiverID", (Object)this.m_aReceiverID).append("DocumentTypeID", (Object)this.m_aDocumentTypeID).append("ProcessID", (Object)this.m_aProcessID).toString();
    }
}

