/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.client.impl;

import com.helger.commons.string.StringHelper;
import com.helger.peppol.lime.api.MessageMetadata;
import com.helger.peppol.lime.api.MessageMetadataHelper;
import com.helger.peppol.lime.api.wstransfer.Create;
import com.helger.peppol.lime.api.wstransfer.CreateResponse;
import com.helger.peppol.lime.api.wstransfer.Put;
import com.helger.peppol.lime.api.wstransfer.Resource;
import com.helger.peppol.lime.api.wstransfer.ResourceCreated;
import com.helger.peppol.lime.client.CLimeIdentifiers;
import com.helger.peppol.lime.client.IEndpointReference;
import com.helger.peppol.lime.client.IMessage;
import com.helger.peppol.lime.client.IOutbox;
import com.helger.peppol.lime.client.MessageException;
import com.helger.peppol.lime.client.impl.EndpointReferenceWithMessageID;
import com.helger.peppol.lime.client.impl.LimeHelper;
import com.helger.peppol.lime.client.username.IUsernamePWCredentials;
import com.helger.peppol.utils.W3CEndpointReferenceHelper;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class Outbox
implements IOutbox {
    private static final Logger s_aLogger = LoggerFactory.getLogger(Outbox.class);

    private static void _validateCredentials(@Nonnull IUsernamePWCredentials iUsernamePWCredentials) throws MessageException {
        if (iUsernamePWCredentials == null) {
            throw new MessageException("Credentials can not be a null value");
        }
        if (StringHelper.hasNoTextAfterTrim((String)iUsernamePWCredentials.getUsername()) || StringHelper.hasNoTextAfterTrim((String)iUsernamePWCredentials.getPassword())) {
            throw new MessageException("Credentials are invalid, username=" + iUsernamePWCredentials.getUsername() + " password=" + iUsernamePWCredentials.getPassword());
        }
    }

    @Nonnull
    private static EndpointReferenceWithMessageID _createEndpointReferenceDocument(@Nonnull CreateResponse createResponse) {
        ResourceCreated resourceCreated = (ResourceCreated)createResponse.getAny();
        if (resourceCreated == null && (resourceCreated = createResponse.getResourceCreated()) == null) {
            throw new IllegalStateException("No content of create response!");
        }
        W3CEndpointReference w3CEndpointReference = resourceCreated.getEndpointReference().get(0);
        EndpointReferenceWithMessageID endpointReferenceWithMessageID = new EndpointReferenceWithMessageID();
        endpointReferenceWithMessageID.setAddress(W3CEndpointReferenceHelper.getAddress((W3CEndpointReference)w3CEndpointReference));
        for (Element element : W3CEndpointReferenceHelper.getReferenceParameters((W3CEndpointReference)w3CEndpointReference)) {
            if ("ChannelIdentifier".equals(element.getLocalName())) {
                endpointReferenceWithMessageID.setChannelID(element.getTextContent());
                continue;
            }
            if ("MessageIdentifier".equals(element.getLocalName())) {
                endpointReferenceWithMessageID.setMessageID(element.getTextContent());
                continue;
            }
            s_aLogger.warn("EndpointReference contains illegal element " + element.getLocalName());
        }
        return endpointReferenceWithMessageID;
    }

    @Override
    public String sendMessage(@Nonnull IUsernamePWCredentials iUsernamePWCredentials, @Nonnull IMessage iMessage, @Nonnull IEndpointReference iEndpointReference) throws MessageException {
        Outbox._validateCredentials(iUsernamePWCredentials);
        try {
            MessageMetadata messageMetadata = new MessageMetadata(null, iEndpointReference.getChannelID(), iMessage.getSenderID(), iMessage.getReceiverID(), iMessage.getDocumentTypeID(), iMessage.getProcessID() != null ? iMessage.getProcessID() : CLimeIdentifiers.MESSAGEUNDELIVERABLE_PROCESS);
            Resource resource = LimeHelper.createServicePort(iEndpointReference.getAddress(), iUsernamePWCredentials);
            List<Header> list = MessageMetadataHelper.createHeadersFromMetadata(messageMetadata);
            ((WSBindingProvider)resource).setOutboundHeaders(list);
            CreateResponse createResponse = resource.create(new Create());
            EndpointReferenceWithMessageID endpointReferenceWithMessageID = Outbox._createEndpointReferenceDocument(createResponse);
            resource = LimeHelper.createServicePort(endpointReferenceWithMessageID.getAddress(), iUsernamePWCredentials);
            list = MessageMetadataHelper.createHeadersFromMetadata(endpointReferenceWithMessageID);
            ((WSBindingProvider)resource).setOutboundHeaders(list);
            Put put = new Put();
            put.getAny().add(iMessage.getDocument().getDocumentElement());
            resource.put(put);
            return endpointReferenceWithMessageID.getMessageID();
        }
        catch (Exception exception) {
            s_aLogger.warn("Outbox error", (Throwable)exception);
            throw new MessageException(exception);
        }
    }
}

