/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.client.soapheader;

import com.helger.jaxb.JAXBContextCache;
import com.helger.jaxb.JAXBMarshallerHelper;
import com.helger.peppol.identifier.ObjectFactory;
import com.helger.peppol.identifier.ParticipantIdentifierType;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class SoapHeaderHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger s_aLogger = LoggerFactory.getLogger((String)SoapHeaderHandler.class.getName());
    private final String m_sChannelID;
    private final String m_sMessageID;
    private final List<Element> m_aReferenceParameters;

    public SoapHeaderHandler(@Nullable String string, @Nullable String string2, @Nullable List<Element> list) {
        this.m_sMessageID = string2;
        this.m_sChannelID = string;
        this.m_aReferenceParameters = list;
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (((Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            try {
                SOAPEnvelope sOAPEnvelope = sOAPMessageContext.getMessage().getSOAPPart().getEnvelope();
                this._createSOAPHeader(sOAPEnvelope);
            }
            catch (Exception exception) {
                s_aLogger.warn("Failed to set header", (Throwable)exception);
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleFault(SOAPMessageContext sOAPMessageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    private void _createSOAPHeader(@Nonnull SOAPEnvelope sOAPEnvelope) throws Exception {
        SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
        if (sOAPHeader == null) {
            sOAPHeader = sOAPEnvelope.addHeader();
        }
        ObjectFactory objectFactory = new ObjectFactory();
        Marshaller marshaller = JAXBContextCache.getInstance().getFromCache(ParticipantIdentifierType.class.getPackage()).createMarshaller();
        JAXBMarshallerHelper.setFormattedOutput((Marshaller)marshaller, (boolean)true);
        marshaller = JAXBContext.newInstance((Class[])new Class[]{String.class}).createMarshaller();
        if (this.m_sChannelID != null) {
            marshaller.marshal((Object)objectFactory.createChannelIdentifier(this.m_sChannelID), (Result)new DOMResult((Node)sOAPHeader));
        }
        if (this.m_sMessageID != null) {
            marshaller.marshal((Object)objectFactory.createMessageIdentifier(this.m_sMessageID), (Result)new DOMResult((Node)sOAPHeader));
        }
        if (this.m_aReferenceParameters != null) {
            try {
                for (Element element : this.m_aReferenceParameters) {
                    SOAPElement sOAPElement = sOAPHeader.addChildElement(new QName(element.getNamespaceURI(), element.getLocalName()));
                    sOAPElement.setTextContent(element.getTextContent());
                }
            }
            catch (Exception exception) {
                s_aLogger.error("Unable to set reference parameters: " + this.m_aReferenceParameters, (Throwable)exception);
                throw exception;
            }
        }
    }
}

