/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.lime.client.username;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.lime.client.username.IUsernamePWCredentials;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class UsernamePWCredentials
implements IUsernamePWCredentials {
    private static final Logger s_aLogger = LoggerFactory.getLogger(UsernamePWCredentials.class);
    private final String m_sUsername;
    private final String m_sPassword;

    public UsernamePWCredentials(@Nonnull @Nonempty String string, @Nullable String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Username");
        if (string.indexOf(58) >= 0) {
            s_aLogger.error("The user name '" + string + "' contains a ':' character which prevents it from being correctly converted to an HTTP basic authentication value!!!");
        }
        this.m_sUsername = string;
        this.m_sPassword = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getUsername() {
        return this.m_sUsername;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UsernamePWCredentials usernamePWCredentials = (UsernamePWCredentials)object;
        return EqualsHelper.equals((Object)this.m_sUsername, (Object)usernamePWCredentials.m_sUsername) && EqualsHelper.equals((Object)this.m_sPassword, (Object)usernamePWCredentials.m_sPassword);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sUsername).append((Object)this.m_sPassword).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("username", (Object)this.m_sUsername).appendPassword("password").toString();
    }
}

