/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.bdxrclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.mime.CMimeType;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.bdxr.ParticipantIdentifierType;
import com.helger.peppol.bdxr.RedirectType;
import com.helger.peppol.bdxr.ServiceGroupType;
import com.helger.peppol.bdxr.ServiceInformationType;
import com.helger.peppol.bdxr.ServiceMetadataType;
import com.helger.peppol.bdxr.marshal.BDXRMarshallerServiceGroupType;
import com.helger.peppol.bdxr.marshal.BDXRMarshallerServiceMetadataType;
import com.helger.peppol.bdxrclient.BDXRClientReadOnly;
import com.helger.peppol.httpclient.SMPHttpResponseHandlerWriteOperations;
import com.helger.peppol.identifier.bdxr.participant.BDXRParticipantIdentifier;
import com.helger.peppol.identifier.generic.doctype.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smpclient.exception.SMPClientException;
import com.helger.peppol.url.IPeppolURLProvider;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXRClient
extends BDXRClientReadOnly {
    private static final Logger s_aLogger = LoggerFactory.getLogger(BDXRClient.class);
    private static final ContentType CONTENT_TYPE_TEXT_XML = ContentType.create((String)CMimeType.TEXT_XML.getAsString(), (Charset)StandardCharsets.UTF_8);

    public BDXRClient(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) {
        super(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo);
    }

    public BDXRClient(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) {
        super(iPeppolURLProvider, iParticipantIdentifier, string);
    }

    public BDXRClient(@Nonnull URI uRI) {
        super(uRI);
    }

    public void saveServiceGroup(@Nonnull ServiceGroupType serviceGroupType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceGroupType, (String)"ServiceGroup");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = new BDXRMarshallerServiceGroupType().getAsString((Object)serviceGroupType);
        String string2 = this.getSMPHostURI() + serviceGroupType.getParticipantIdentifier().getURIPercentEncoded();
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("BDXRClient saveServiceGroup@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequest)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Nonnull
    public ServiceGroupType saveServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantIdentifier((ParticipantIdentifierType)new BDXRParticipantIdentifier(iParticipantIdentifier));
        this.saveServiceGroup(serviceGroupType, basicAuthClientCredentials);
        return serviceGroupType;
    }

    public void deleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("BDXRClient deleteServiceGroup@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequest)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }

    private void _saveServiceInformation(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        String string = new BDXRMarshallerServiceMetadataType().getAsString((Object)serviceMetadataType);
        String string2 = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("BDXRClient saveServiceRegistration@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequest)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Deprecated
    public void saveServiceRegistration(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"ServiceMetadata");
        ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
        ValueEnforcer.notNull((Object)serviceInformationType, (String)"ServiceMetadata.ServiceInformation");
        ValueEnforcer.notNull((Object)serviceInformationType.getParticipantIdentifier(), (String)"ServiceMetadata.ServiceInformation.ParticipantIdentifier");
        ValueEnforcer.notNull((Object)serviceInformationType.getDocumentIdentifier(), (String)"ServiceMetadata.ServiceInformation.DocumentIdentifier");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        this._saveServiceInformation((IParticipantIdentifier)serviceInformationType.getParticipantIdentifier(), (IDocumentTypeIdentifier)serviceInformationType.getDocumentIdentifier(), serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceInformation(@Nonnull ServiceInformationType serviceInformationType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceInformationType, (String)"ServiceMetadata.ServiceInformation");
        ValueEnforcer.notNull((Object)serviceInformationType.getParticipantIdentifier(), (String)"ServiceMetadata.ServiceInformation.ParticipantIdentifier");
        ValueEnforcer.notNull((Object)serviceInformationType.getDocumentIdentifier(), (String)"ServiceMetadata.ServiceInformation.DocumentIdentifier");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setServiceInformation(serviceInformationType);
        this._saveServiceInformation((IParticipantIdentifier)serviceInformationType.getParticipantIdentifier(), (IDocumentTypeIdentifier)serviceInformationType.getDocumentIdentifier(), serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceRedirect(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull RedirectType redirectType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)redirectType, (String)"Redirect");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setRedirect(redirectType);
        this._saveServiceInformation(iParticipantIdentifier, iDocumentTypeIdentifier, serviceMetadataType, basicAuthClientCredentials);
    }

    public void deleteServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("BDXRClient deleteServiceRegistration@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequest)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }
}

