/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.bdxrclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.peppol.bdxr.EndpointType;
import com.helger.peppol.bdxr.ProcessType;
import com.helger.peppol.bdxr.RedirectType;
import com.helger.peppol.bdxr.ServiceGroupType;
import com.helger.peppol.bdxr.ServiceInformationType;
import com.helger.peppol.bdxr.SignedServiceMetadataType;
import com.helger.peppol.bdxr.marshal.BDXRMarshallerServiceGroupType;
import com.helger.peppol.bdxr.marshal.BDXRMarshallerSignedServiceMetadataType;
import com.helger.peppol.httpclient.AbstractGenericSMPClient;
import com.helger.peppol.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.peppol.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.peppol.identifier.generic.doctype.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.generic.participant.IParticipantIdentifier;
import com.helger.peppol.identifier.generic.process.IProcessIdentifier;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppol.smpclient.exception.SMPClientException;
import com.helger.peppol.smpclient.exception.SMPClientNotFoundException;
import com.helger.peppol.url.IPeppolURLProvider;
import com.helger.security.certificate.CertificateHelper;
import com.helger.xsds.xmldsig.X509DataType;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXRClientReadOnly
extends AbstractGenericSMPClient<BDXRClientReadOnly> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(BDXRClientReadOnly.class);

    public BDXRClientReadOnly(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) {
        this(iPeppolURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public BDXRClientReadOnly(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) {
        this(iPeppolURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public BDXRClientReadOnly(@Nonnull URI uRI) {
        super(uRI);
    }

    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("BDXRClient getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        return (ServiceGroupType)this.executeGenericRequest((HttpUriRequest)httpGet, new SMPHttpResponseHandlerUnsigned(new BDXRMarshallerServiceGroupType()));
    }

    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public SignedServiceMetadataType getServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        HttpGet httpGet;
        SignedServiceMetadataType signedServiceMetadataType;
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("BDXRClient getServiceRegistration@" + string);
        }
        if ((signedServiceMetadataType = (SignedServiceMetadataType)this.executeGenericRequest((HttpUriRequest)(httpGet = new HttpGet(string)), new SMPHttpResponseHandlerSigned(new BDXRMarshallerSignedServiceMetadataType()).setCheckCertificate(this.isCheckCertificate()))).getServiceMetadata() != null && signedServiceMetadataType.getServiceMetadata().getRedirect() != null) {
            RedirectType redirectType = signedServiceMetadataType.getServiceMetadata().getRedirect();
            s_aLogger.info("Following a redirect from '" + string + "' to '" + redirectType.getHref() + "'");
            httpGet = new HttpGet(redirectType.getHref());
            signedServiceMetadataType = (SignedServiceMetadataType)this.executeGenericRequest((HttpUriRequest)httpGet, new SMPHttpResponseHandlerSigned(new BDXRMarshallerSignedServiceMetadataType()).setCheckCertificate(this.isCheckCertificate()));
            boolean bl = false;
            block0: for (Object e : signedServiceMetadataType.getSignature().getKeyInfo().getContent()) {
                Object object = ((JAXBElement)e).getValue();
                if (!(object instanceof X509DataType)) continue;
                X509DataType x509DataType = (X509DataType)object;
                for (Object e2 : x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                    JAXBElement jAXBElement = (JAXBElement)e2;
                    if (!(jAXBElement.getValue() instanceof String)) continue;
                    String string2 = (String)jAXBElement.getValue();
                    if (!redirectType.getCertificateUID().equals(string2)) {
                        throw new SMPClientException("The certificate UID of the redirect did not match the certificate subject. Subject is '" + string2 + "'. Required certificate UID is '" + redirectType.getCertificateUID() + "'");
                    }
                    bl = true;
                    break block0;
                }
            }
            if (!bl) {
                throw new SMPClientException("The X509 certificate did not contain a certificate subject.");
            }
        }
        return signedServiceMetadataType;
    }

    @Nullable
    public SignedServiceMetadataType getServiceRegistrationOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        try {
            return this.getServiceRegistration(iParticipantIdentifier, iDocumentTypeIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nullable
    public EndpointType getEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"serviceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        SignedServiceMetadataType signedServiceMetadataType = this.getServiceRegistrationOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
        return signedServiceMetadataType == null ? null : BDXRClientReadOnly.getEndpoint(signedServiceMetadataType, iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)signedServiceMetadataType, (String)"SignedServiceMetadata");
        ValueEnforcer.notNull((Object)signedServiceMetadataType.getServiceMetadata(), (String)"SignedServiceMetadata.ServiceMetadata");
        if (signedServiceMetadataType.getServiceMetadata().getServiceInformation() == null) {
            return null;
        }
        ValueEnforcer.notNull((Object)signedServiceMetadataType.getServiceMetadata().getServiceInformation().getProcessList(), (String)"SignedServiceMetadata.ServiceMetadata.ServiceInformation.ProcessList");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        ServiceInformationType serviceInformationType = signedServiceMetadataType.getServiceMetadata().getServiceInformation();
        if (serviceInformationType != null) {
            for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
                if (!processType.getProcessIdentifier().equals((Object)iProcessIdentifier)) continue;
                CommonsArrayList commonsArrayList = new CommonsArrayList();
                for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                    if (!iSMPTransportProfile.getID().equals(endpointType.getTransportProfile())) continue;
                    commonsArrayList.add((Object)endpointType);
                }
                if (commonsArrayList.size() != 1) {
                    s_aLogger.warn("Found " + commonsArrayList.size() + " endpoints for process " + iProcessIdentifier + " and transport profile " + iSMPTransportProfile.getID() + (commonsArrayList.isEmpty() ? "" : ": " + commonsArrayList.toString() + " - using the first one"));
                }
                return (EndpointType)commonsArrayList.getFirst();
            }
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getEndpointURI();
    }

    @Nullable
    public String getEndpointAddress(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXRClientReadOnly.getEndpointAddress(endpointType);
    }

    @Nullable
    public static byte[] getEndpointCertificateString(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getCertificate();
    }

    @Nullable
    public byte[] getEndpointCertificateString(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXRClientReadOnly.getEndpointCertificateString(endpointType);
    }

    @Nullable
    public X509Certificate getEndpointCertificate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException, CertificateException {
        byte[] byArray = this.getEndpointCertificateString(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return CertificateHelper.convertByteArrayToCertficate((byte[])byArray);
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        byte[] byArray = BDXRClientReadOnly.getEndpointCertificateString(endpointType);
        return CertificateHelper.convertByteArrayToCertficate((byte[])byArray);
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        return new BDXRClientReadOnly(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static SignedServiceMetadataType getServiceRegistrationByDNS(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return new BDXRClientReadOnly(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo).getServiceRegistration(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

