/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.peppol.smpclient.SMPClientConfiguration;
import com.helger.peppol.smpclient.exception.SMPClientBadRequestException;
import com.helger.peppol.smpclient.exception.SMPClientException;
import com.helger.peppol.smpclient.exception.SMPClientNotFoundException;
import com.helger.peppol.smpclient.exception.SMPClientUnauthorizedException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericSMPClient<IMPLTYPE extends AbstractGenericSMPClient<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractGenericSMPClient.class);
    private final String m_sSMPHost;
    private HttpHost m_aProxy;
    private Credentials m_aProxyCredentials;
    private boolean m_bUseProxySystemProperties;
    private boolean m_bUseDNSClientCache;
    private int m_nConnectionTimeoutMS = 5000;
    private int m_nRequestTimeoutMS = 10000;
    private boolean m_bCheckCertificate = true;

    public AbstractGenericSMPClient(@Nonnull URI uRI) {
        String string;
        ValueEnforcer.notNull((Object)uRI, (String)"SMPHost");
        if (!"http".equals(uRI.getScheme())) {
            s_aLogger.warn("SMP URI " + uRI + " does not use the expected http scheme!");
        }
        if (uRI.getPort() != 80 && uRI.getPort() != -1) {
            s_aLogger.warn("SMP URI " + uRI + " is not running on port 80!");
        }
        this.m_sSMPHost = (string = uRI.toString()).endsWith("/") ? string : string + '/';
        this.m_aProxy = SMPClientConfiguration.getHttpProxy();
        this.m_aProxyCredentials = SMPClientConfiguration.getHttpProxyCredentials();
        this.m_bUseProxySystemProperties = SMPClientConfiguration.isUseProxySystemProperties();
        this.m_bUseDNSClientCache = SMPClientConfiguration.isUseDNSClientCache();
    }

    @Nonnull
    public String getSMPHostURI() {
        return this.m_sSMPHost;
    }

    @Nullable
    public HttpHost getProxy() {
        return this.m_aProxy;
    }

    @Nonnull
    public IMPLTYPE setProxy(@Nullable HttpHost httpHost) {
        this.m_aProxy = httpHost;
        if (httpHost != null && this.m_bUseProxySystemProperties) {
            s_aLogger.warn("Since an explicit Proxy host for all servers is defined, the usage of the system properties is disabled.");
            this.m_bUseProxySystemProperties = false;
        }
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nullable
    public Credentials getProxyCredentials() {
        return this.m_aProxyCredentials;
    }

    @Nonnull
    public IMPLTYPE setProxyCredentials(@Nullable Credentials credentials) {
        this.m_aProxyCredentials = credentials;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public boolean isUseProxySystemProperties() {
        return this.m_bUseProxySystemProperties;
    }

    @Nonnull
    public IMPLTYPE setUseProxySystemProperties(boolean bl) {
        this.m_bUseProxySystemProperties = bl;
        if (bl && this.m_aProxy != null) {
            s_aLogger.warn("Since the proxy system properties should be used, the explicit Proxy is removed.");
            this.m_aProxy = null;
        }
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public boolean isUseDNSClientCache() {
        return this.m_bUseDNSClientCache;
    }

    @Nonnull
    public IMPLTYPE setUseDNSClientCache(boolean bl) {
        this.m_bUseDNSClientCache = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public int getConnectionTimeoutMS() {
        return this.m_nConnectionTimeoutMS;
    }

    @Nonnull
    public IMPLTYPE setConnectionTimeoutMS(int n) {
        this.m_nConnectionTimeoutMS = n;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public int getRequestTimeoutMS() {
        return this.m_nRequestTimeoutMS;
    }

    @Nonnull
    public IMPLTYPE setRequestTimeoutMS(int n) {
        this.m_nRequestTimeoutMS = n;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE setCheckCertificate(boolean bl) {
        this.m_bCheckCertificate = bl;
        return (IMPLTYPE)((AbstractGenericSMPClient)this.thisAsT());
    }

    public boolean isCheckCertificate() {
        return this.m_bCheckCertificate;
    }

    @Nonnull
    @OverrideOnDemand
    protected HttpContext createHttpContext() {
        RequestConfig.Builder builder = RequestConfig.custom();
        if (this.m_aProxy != null) {
            builder.setProxy(this.m_aProxy);
        }
        if (this.m_nConnectionTimeoutMS > 0) {
            builder.setConnectTimeout(this.m_nConnectionTimeoutMS);
        }
        if (this.m_nRequestTimeoutMS > 0) {
            builder.setSocketTimeout(this.m_nRequestTimeoutMS);
        }
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setRequestConfig(builder.build());
        return httpClientContext;
    }

    @Nonnull
    public <T> T executeRequest(@Nonnull HttpUriRequest httpUriRequest, @Nonnull ResponseHandler<T> responseHandler) throws IOException {
        HttpClientFactory httpClientFactory = new HttpClientFactory();
        httpClientFactory.setUseSystemProperties(this.m_bUseProxySystemProperties);
        httpClientFactory.setUseDNSClientCache(this.m_bUseDNSClientCache);
        httpClientFactory.setProxy(this.m_aProxy, this.m_aProxyCredentials);
        HttpContext httpContext = this.createHttpContext();
        try (HttpClientManager httpClientManager = new HttpClientManager((IHttpClientProvider)httpClientFactory);){
            Object object = httpClientManager.execute(httpUriRequest, httpContext, responseHandler);
            return (T)object;
        }
    }

    @Nonnull
    public static SMPClientException getConvertedException(@Nonnull Exception exception) {
        if (exception instanceof SMPClientException) {
            return (SMPClientException)exception;
        }
        if (exception instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)exception;
            int n = httpResponseException.getStatusCode();
            switch (n) {
                case 400: {
                    return new SMPClientBadRequestException(httpResponseException);
                }
                case 403: {
                    return new SMPClientUnauthorizedException(httpResponseException);
                }
                case 404: {
                    return new SMPClientNotFoundException(httpResponseException);
                }
            }
            return new SMPClientException("Error thrown with HTTP status code " + n, (Throwable)httpResponseException);
        }
        if (exception instanceof UnknownHostException) {
            return new SMPClientNotFoundException((UnknownHostException)exception);
        }
        if (exception instanceof ConnectException) {
            return new SMPClientNotFoundException((ConnectException)exception);
        }
        return new SMPClientException("Unknown error thrown by SMP server (" + exception.getMessage() + ")", exception);
    }

    @Nonnull
    public <T> T executeGenericRequest(@Nonnull HttpUriRequest httpUriRequest, @Nonnull ResponseHandler<T> responseHandler) throws SMPClientException {
        try {
            return this.executeRequest(httpUriRequest, responseHandler);
        }
        catch (Exception exception) {
            throw AbstractGenericSMPClient.getConvertedException(exception);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SMPHost", (Object)this.m_sSMPHost).appendIfNotNull("Proxy", (Object)this.m_aProxy).append("UseProxySystemProperties", this.m_bUseProxySystemProperties).append("UseDNSClientCache", this.m_bUseDNSClientCache).append("ConnectionTimeoutMS", this.m_nConnectionTimeoutMS).append("RequestTimeoutMS", this.m_nRequestTimeoutMS).append("CheckCertificate", this.m_bCheckCertificate).getToString();
    }
}

