/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.jaxb.AbstractJAXBMarshaller;
import com.helger.peppol.httpclient.AbstractSMPResponseHandler;
import com.helger.peppol.httpclient.TrustStoreBasedX509KeySelector;
import com.helger.xml.serialize.read.DOMReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SMPHttpResponseHandlerSigned<T>
extends AbstractSMPResponseHandler<T> {
    public static final boolean DEFAULT_CHECK_CERTIFICATE = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger(SMPHttpResponseHandlerSigned.class);
    private final AbstractJAXBMarshaller<T> m_aMarshaller;
    private boolean m_bCheckCertificate = true;

    public SMPHttpResponseHandlerSigned(@Nonnull AbstractJAXBMarshaller<T> abstractJAXBMarshaller) {
        this.m_aMarshaller = (AbstractJAXBMarshaller)ValueEnforcer.notNull(abstractJAXBMarshaller, (String)"Marshaller");
    }

    @Nonnull
    public SMPHttpResponseHandlerSigned<T> setCheckCertificate(boolean bl) {
        this.m_bCheckCertificate = bl;
        return this;
    }

    public boolean isCheckCertificate() {
        return this.m_bCheckCertificate;
    }

    private static boolean _checkSignature(@Nonnull @WillNotClose InputStream inputStream) throws Exception {
        Document document = DOMReader.readXMLDOM((InputStream)inputStream);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new IllegalArgumentException("Element <Signature> not found in SMP XML response");
        }
        TrustStoreBasedX509KeySelector trustStoreBasedX509KeySelector = new TrustStoreBasedX509KeySelector();
        DOMValidateContext dOMValidateContext = new DOMValidateContext(trustStoreBasedX509KeySelector, nodeList.item(0));
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
        boolean bl = xMLSignature.validate(dOMValidateContext);
        if (!bl) {
            s_aLogger.info("Signature failed core validation");
            boolean bl2 = xMLSignature.getSignatureValue().validate(dOMValidateContext);
            s_aLogger.info("  Signature value valid: " + bl2);
            if (!bl2) {
                int n = 0;
                Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
                while (iterator.hasNext()) {
                    boolean bl3 = iterator.next().validate(dOMValidateContext);
                    s_aLogger.info("  Reference[" + n + "] validity status: " + (bl3 ? "valid" : "NOT valid!"));
                    ++n;
                }
            }
        }
        return bl;
    }

    @Override
    @Nonnull
    public T handleEntity(@Nonnull HttpEntity httpEntity) throws IOException {
        Object object;
        byte[] byArray;
        block18: {
            byArray = StreamHelper.getAllBytes((InputStream)httpEntity.getContent());
            if (ArrayHelper.isEmpty((byte[])byArray)) {
                throw new ClientProtocolException("Could not read SMP server response content");
            }
            if (this.m_bCheckCertificate) {
                try {
                    object = new NonBlockingByteArrayInputStream(byArray);
                    Throwable throwable = null;
                    try {
                        if (!SMPHttpResponseHandlerSigned._checkSignature((InputStream)object)) {
                            throw new ClientProtocolException("Signature returned from SMP server was not valid");
                        }
                        break block18;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    throw new ClientProtocolException("Error in validating signature returned from SMP server", (Throwable)exception);
                }
            }
            s_aLogger.warn("SMP response certificate checking is disabled. This should not happen in production systems!");
        }
        object = this.m_aMarshaller.read(byArray);
        if (object == null) {
            throw new ClientProtocolException("Malformed XML document returned from SMP server");
        }
        return (T)object;
    }
}

