/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.httpclient.HttpClientHelper;
import com.helger.jaxb.AbstractJAXBMarshaller;
import com.helger.peppol.httpclient.AbstractSMPResponseHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.ContentType;

public class SMPHttpResponseHandlerUnsigned<T>
extends AbstractSMPResponseHandler<T> {
    private final AbstractJAXBMarshaller<T> m_aMarshaller;

    public SMPHttpResponseHandlerUnsigned(@Nonnull AbstractJAXBMarshaller<T> abstractJAXBMarshaller) {
        this.m_aMarshaller = (AbstractJAXBMarshaller)ValueEnforcer.notNull(abstractJAXBMarshaller, (String)"Marshaller");
    }

    @Override
    @Nonnull
    public T handleEntity(@Nonnull HttpEntity httpEntity) throws IOException {
        ContentType contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
        Charset charset = HttpClientHelper.getCharset((ContentType)contentType);
        InputStreamReader inputStreamReader = new InputStreamReader(httpEntity.getContent(), charset);
        Object object = this.m_aMarshaller.read((Reader)inputStreamReader);
        if (object == null) {
            throw new ClientProtocolException("Malformed XML document returned from SMP server");
        }
        return (T)object;
    }
}

