/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.httpclient;

import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.peppol.smpclient.SMPClientConfiguration;
import com.helger.security.certificate.CertificateHelper;
import com.helger.security.keystore.ConstantKeySelectorResult;
import com.helger.security.keystore.KeyStoreHelper;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrustStoreBasedX509KeySelector
extends KeySelector {
    private static final Logger s_aLogger = LoggerFactory.getLogger(TrustStoreBasedX509KeySelector.class);
    private final String m_sTrustoreLocation = SMPClientConfiguration.getTruststoreLocation();
    private final String m_sTrustStorePassword = SMPClientConfiguration.getTruststorePassword();
    private transient KeyStore m_aKeyStore;

    public static boolean algorithmEquals(@Nonnull String string, @Nonnull String string2) {
        if (string2.equalsIgnoreCase("DSA") ? string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") : (string2.equalsIgnoreCase("RSA") ? string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1") : string2.equalsIgnoreCase("EC") && string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"))) {
            return true;
        }
        s_aLogger.warn("Algorithm mismatch between JCA/JCE public key algorithm name ('" + string2 + "') and signature algorithm URI ('" + string + "')");
        return false;
    }

    @Override
    public KeySelectorResult select(@Nonnull KeyInfo keyInfo, KeySelector.Purpose purpose, @Nonnull AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        for (XMLStructure xMLStructure : keyInfo.getContent()) {
            if (!(xMLStructure instanceof X509Data)) continue;
            X509Data x509Data = (X509Data)xMLStructure;
            for (Object obj : x509Data.getContent()) {
                if (!(obj instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)obj;
                try {
                    x509Certificate.checkValidity();
                    Object[] objectArray = new X509Certificate[]{x509Certificate};
                    if (this.m_aKeyStore == null) {
                        this.m_aKeyStore = KeyStoreHelper.loadKeyStoreDirect((String)this.m_sTrustoreLocation, (String)this.m_sTrustStorePassword);
                    }
                    PKIXParameters pKIXParameters = new PKIXParameters(this.m_aKeyStore);
                    pKIXParameters.setRevocationEnabled(false);
                    CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
                    CertPath certPath = certificateFactory.generateCertPath((List<? extends Certificate>)new CommonsArrayList(objectArray));
                    CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
                    certPathValidator.validate(certPath, pKIXParameters);
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    if (!TrustStoreBasedX509KeySelector.algorithmEquals(algorithmMethod.getAlgorithm(), publicKey.getAlgorithm())) continue;
                    return new ConstantKeySelectorResult((Key)publicKey);
                }
                catch (Throwable throwable) {
                    throw new KeySelectorException("Failed to select public key from certificate " + x509Certificate, throwable);
                }
            }
        }
        throw new KeySelectorException("No public key found!");
    }
}

