/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smpclient;

import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpHost;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SMPClientConfiguration {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SMPClientConfiguration.class);
    private static final ConfigFile s_aConfigFile;

    private SMPClientConfiguration() {
    }

    @Nonnull
    public static ConfigFile getConfigFile() {
        return s_aConfigFile;
    }

    @Nonnull
    public static String getTruststoreLocation() {
        return s_aConfigFile.getAsString((Object)"truststore.location", "truststore/complete-truststore.jks");
    }

    @Nonnull
    public static String getTruststorePassword() {
        return s_aConfigFile.getAsString((Object)"truststore.password", "peppol");
    }

    @Nullable
    public static HttpHost getHttpProxy() {
        String string = s_aConfigFile.getAsString((Object)"http.proxyHost");
        int n = s_aConfigFile.getAsInt((Object)"http.proxyPort", 0);
        if (string != null && n > 0) {
            return new HttpHost(string, n);
        }
        return null;
    }

    @Nullable
    public static UsernamePasswordCredentials getHttpProxyCredentials() {
        String string = s_aConfigFile.getAsString((Object)"http.proxyUsername");
        String string2 = s_aConfigFile.getAsString((Object)"http.proxyPassword");
        if (string != null && string2 != null) {
            return new UsernamePasswordCredentials(string, string2);
        }
        return null;
    }

    public static boolean isUseProxySystemProperties() {
        return s_aConfigFile.getAsBoolean((Object)"http.useSystemProperties", false);
    }

    public static boolean isUseDNSClientCache() {
        return s_aConfigFile.getAsBoolean((Object)"http.useDNSClientCache", true);
    }

    static {
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder().addPathFromSystemProperty("peppol.smp.client.properties.path").addPathFromSystemProperty("smp.client.properties.path").addPath("private-smp-client.properties").addPath("smp-client.properties");
        s_aConfigFile = configFileBuilder.build();
        if (s_aConfigFile.isRead()) {
            s_aLogger.info("Read PEPPOL SMP client properties from " + s_aConfigFile.getReadResource().getPath());
        } else {
            s_aLogger.warn("Failed to read PEPPOL SMP client properties from " + configFileBuilder.getAllPaths());
        }
    }
}

