/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smpserver.app;

import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.scope.singleton.AbstractGlobalSingleton;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.properties.SettingsPersistenceProperties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppSettings
extends AbstractGlobalSingleton {
    public static final String FILENAME = "webapp.properties";
    private static final Logger s_aLogger = LoggerFactory.getLogger(AppSettings.class);
    private static final IReadableResource s_aRes;
    private static final ISettings s_aSettings;

    @Deprecated
    @UsedViaReflection
    private AppSettings() {
    }

    @Nonnull
    public static ISettings getSettingsObject() {
        return s_aSettings;
    }

    @Nonnull
    public static IReadableResource getSettingsResource() {
        return s_aRes;
    }

    @Nullable
    public static String getGlobalDebug() {
        return s_aSettings.getStringValue("global.debug");
    }

    @Nullable
    public static String getGlobalProduction() {
        return s_aSettings.getStringValue("global.production");
    }

    @Nullable
    public static String getDataPath() {
        return s_aSettings.getStringValue("webapp.datapath");
    }

    public static boolean isCheckFileAccess() {
        return s_aSettings.getBooleanValue("webapp.checkfileaccess", true);
    }

    public static boolean isTestVersion() {
        return s_aSettings.getBooleanValue("webapp.testversion", GlobalDebug.isDebugMode());
    }

    static {
        String string = SystemProperties.getPropertyValue((String)"smp.webapp.properties.path");
        s_aRes = StringHelper.hasText((String)string) ? new FileSystemResource(string) : new ClassPathResource(FILENAME);
        s_aLogger.info("Reading webapp.properties from " + s_aRes.getPath());
        SettingsPersistenceProperties settingsPersistenceProperties = new SettingsPersistenceProperties();
        s_aSettings = settingsPersistenceProperties.readSettings((IHasInputStream)s_aRes);
    }
}

