/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smpserver.rest;

import com.helger.pd.businesscard.ObjectFactory;
import com.helger.pd.businesscard.PDBusinessCardType;
import com.helger.peppol.smpserver.SMPServerConfiguration;
import com.helger.peppol.smpserver.rest.SMPServerAPIDataProvider;
import com.helger.peppol.smpserver.restapi.BusinessCardServerAPI;
import com.helger.peppol.smpserver.restapi.ISMPServerAPIDataProvider;
import com.helger.web.mock.MockHttpServletResponse;
import com.helger.web.scope.mgr.WebScopeManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/businesscard/{ServiceGroupId}")
public final class BusinessCardInterface {
    private static final Logger s_aLogger = LoggerFactory.getLogger(BusinessCardInterface.class);
    @Context
    private HttpServletRequest m_aHttpRequest;
    @Context
    private UriInfo m_aUriInfo;
    private final ObjectFactory m_aObjFactory = new ObjectFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/xml"})
    public JAXBElement<PDBusinessCardType> getBusinessCard(@PathParam(value="ServiceGroupId") String string) throws Throwable {
        if (!SMPServerConfiguration.isPEPPOLDirectoryIntegrationEnabled()) {
            s_aLogger.warn("The PEPPOL Directory integration is disabled. getBusinessCard will not be executed.");
            throw new WebApplicationException(404);
        }
        WebScopeManager.onRequestBegin((String)"public", (HttpServletRequest)this.m_aHttpRequest, (HttpServletResponse)new MockHttpServletResponse());
        try {
            PDBusinessCardType pDBusinessCardType = new BusinessCardServerAPI((ISMPServerAPIDataProvider)new SMPServerAPIDataProvider(this.m_aUriInfo)).getBusinessCard(string);
            JAXBElement jAXBElement = this.m_aObjFactory.createBusinessCard(pDBusinessCardType);
            return jAXBElement;
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }
}

