/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smpserver.rest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.url.URLHelper;
import com.helger.peppol.identifier.IDocumentTypeIdentifier;
import com.helger.peppol.identifier.IIdentifier;
import com.helger.peppol.identifier.IParticipantIdentifier;
import com.helger.peppol.identifier.IdentifierHelper;
import com.helger.peppol.smpserver.SMPServerConfiguration;
import com.helger.peppol.smpserver.rest.ServiceGroupInterface;
import com.helger.peppol.smpserver.rest.ServiceMetadataInterface;
import com.helger.peppol.smpserver.restapi.ISMPServerAPIDataProvider;
import com.helger.web.servlet.server.StaticServerInfo;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class SMPServerAPIDataProvider
implements ISMPServerAPIDataProvider {
    private final UriInfo m_aUriInfo;
    private final boolean m_bUseStaticServerInfo;

    public SMPServerAPIDataProvider(@Nonnull UriInfo uriInfo) {
        this(uriInfo, true);
    }

    public SMPServerAPIDataProvider(@Nonnull UriInfo uriInfo, boolean bl) {
        this.m_aUriInfo = (UriInfo)ValueEnforcer.notNull((Object)uriInfo, (String)"UriInfo");
        this.m_bUseStaticServerInfo = bl;
    }

    @Nonnull
    protected final UriInfo getUriInfo() {
        return this.m_aUriInfo;
    }

    protected final boolean isUseStaticServerInfo() {
        return this.m_bUseStaticServerInfo;
    }

    @Nonnull
    public URI getCurrentURI() {
        if (this.m_bUseStaticServerInfo && StaticServerInfo.isSet()) {
            return URLHelper.getAsURI((String)(StaticServerInfo.getInstance().getFullServerPath() + "/" + this.m_aUriInfo.getPath(false)));
        }
        return this.m_aUriInfo.getAbsolutePath();
    }

    @Nonnull
    protected UriBuilder getBaseUriBuilder() {
        if (this.m_bUseStaticServerInfo && StaticServerInfo.isSet()) {
            return UriBuilder.fromUri((String)(StaticServerInfo.getInstance().getFullServerPath() + "/" + this.m_aUriInfo.getPath(false)));
        }
        return this.m_aUriInfo.getBaseUriBuilder();
    }

    @Nonnull
    public String getServiceGroupHref(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        UriBuilder uriBuilder = this.getBaseUriBuilder();
        if (SMPServerConfiguration.isForceRoot()) {
            uriBuilder = uriBuilder.replacePath("");
        }
        return uriBuilder.path(ServiceGroupInterface.class).buildFromEncoded(new Object[]{IdentifierHelper.getIdentifierURIPercentEncoded((IIdentifier)iParticipantIdentifier)}).toString();
    }

    @Nonnull
    public String getServiceMetadataReferenceHref(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        UriBuilder uriBuilder = this.getBaseUriBuilder();
        if (SMPServerConfiguration.isForceRoot()) {
            uriBuilder = uriBuilder.replacePath("");
        }
        return uriBuilder.path(ServiceMetadataInterface.class).buildFromEncoded(new Object[]{IdentifierHelper.getIdentifierURIPercentEncoded((IIdentifier)iParticipantIdentifier), IdentifierHelper.getIdentifierURIPercentEncoded((IIdentifier)iDocumentTypeIdentifier)}).toString();
    }
}

