/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smpserver.rest;

import com.helger.peppol.smp.ObjectFactory;
import com.helger.peppol.smp.ServiceGroupType;
import com.helger.peppol.smpserver.SMPServerConfiguration;
import com.helger.peppol.smpserver.rest.RestRequestHelper;
import com.helger.peppol.smpserver.rest.SMPServerAPIDataProvider;
import com.helger.peppol.smpserver.restapi.ISMPServerAPIDataProvider;
import com.helger.peppol.smpserver.restapi.SMPServerAPI;
import com.helger.web.mock.MockHttpServletResponse;
import com.helger.web.scope.mgr.WebScopeManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{ServiceGroupId}")
public final class ServiceGroupInterface {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ServiceGroupInterface.class);
    @Context
    private HttpServletRequest m_aHttpRequest;
    @Context
    private HttpHeaders m_aHttpHeaders;
    @Context
    private UriInfo m_aUriInfo;
    private final ObjectFactory m_aObjFactory = new ObjectFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/xml"})
    public JAXBElement<ServiceGroupType> getServiceGroup(@PathParam(value="ServiceGroupId") String string) throws Throwable {
        WebScopeManager.onRequestBegin((String)"public", (HttpServletRequest)this.m_aHttpRequest, (HttpServletResponse)new MockHttpServletResponse());
        try {
            ServiceGroupType serviceGroupType = new SMPServerAPI((ISMPServerAPIDataProvider)new SMPServerAPIDataProvider(this.m_aUriInfo)).getServiceGroup(string);
            JAXBElement jAXBElement = this.m_aObjFactory.createServiceGroup(serviceGroupType);
            return jAXBElement;
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    public Response saveServiceGroup(@PathParam(value="ServiceGroupId") String string, ServiceGroupType serviceGroupType) throws Throwable {
        if (SMPServerConfiguration.isRESTWritableAPIDisabled()) {
            s_aLogger.warn("The writable REST API is disabled. saveServiceGroup will not be executed.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        WebScopeManager.onRequestBegin((String)"public", (HttpServletRequest)this.m_aHttpRequest, (HttpServletResponse)new MockHttpServletResponse());
        try {
            if (new SMPServerAPI((ISMPServerAPIDataProvider)new SMPServerAPIDataProvider(this.m_aUriInfo)).saveServiceGroup(string, serviceGroupType, RestRequestHelper.getAuth((HttpHeaders)this.m_aHttpHeaders)).isFailure()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response;
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }

    @DELETE
    public Response deleteServiceGroup(@PathParam(value="ServiceGroupId") String string) throws Throwable {
        if (SMPServerConfiguration.isRESTWritableAPIDisabled()) {
            s_aLogger.warn("The writable REST API is disabled. deleteServiceGroup will not be executed.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        WebScopeManager.onRequestBegin((String)"public", (HttpServletRequest)this.m_aHttpRequest, (HttpServletResponse)new MockHttpServletResponse());
        try {
            if (new SMPServerAPI((ISMPServerAPIDataProvider)new SMPServerAPIDataProvider(this.m_aUriInfo)).deleteServiceGroup(string, RestRequestHelper.getAuth((HttpHeaders)this.m_aHttpHeaders)).isFailure()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response;
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }
}

