/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smpserver.rest;

import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.xml.transform.XMLTransformerFactory;
import com.helger.peppol.smp.ServiceMetadataType;
import com.helger.peppol.smp.SignedServiceMetadataType;
import com.helger.peppol.smpserver.SMPServerConfiguration;
import com.helger.peppol.smpserver.jaxb.MarshallerSMPSignedServiceMetadataType;
import com.helger.peppol.smpserver.rest.RestRequestHelper;
import com.helger.peppol.smpserver.rest.SMPServerAPIDataProvider;
import com.helger.peppol.smpserver.restapi.ISMPServerAPIDataProvider;
import com.helger.peppol.smpserver.restapi.SMPServerAPI;
import com.helger.peppol.smpserver.security.SMPKeyManager;
import com.helger.web.mock.MockHttpServletResponse;
import com.helger.web.scope.mgr.WebScopeManager;
import java.io.Closeable;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Path(value="/{ServiceGroupId}/services/{DocumentTypeId}")
public final class ServiceMetadataInterface {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ServiceMetadataInterface.class);
    @Context
    private HttpServletRequest m_aHttpRequest;
    @Context
    private HttpHeaders m_aHttpHeaders;
    @Context
    private UriInfo m_aUriInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/xml"})
    public byte[] getServiceRegistration(@PathParam(value="ServiceGroupId") String string, @PathParam(value="DocumentTypeId") String string2) throws Throwable {
        WebScopeManager.onRequestBegin((String)"public", (HttpServletRequest)this.m_aHttpRequest, (HttpServletResponse)new MockHttpServletResponse());
        try {
            SignedServiceMetadataType signedServiceMetadataType = new SMPServerAPI((ISMPServerAPIDataProvider)new SMPServerAPIDataProvider(this.m_aUriInfo)).getServiceRegistration(string, string2);
            MarshallerSMPSignedServiceMetadataType marshallerSMPSignedServiceMetadataType = new MarshallerSMPSignedServiceMetadataType();
            Document document = marshallerSMPSignedServiceMetadataType.write((Object)signedServiceMetadataType);
            try {
                SMPKeyManager.getInstance().signXML(document.getDocumentElement());
            }
            catch (Exception exception) {
                throw new RuntimeException("Error in signing xml", exception);
            }
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            try {
                XMLTransformerFactory.newTransformer().transform(new DOMSource(document), new StreamResult((OutputStream)nonBlockingByteArrayOutputStream));
            }
            catch (TransformerException transformerException) {
                throw new IllegalStateException("Failed to save to XML", transformerException);
            }
            finally {
                StreamHelper.close((Closeable)nonBlockingByteArrayOutputStream);
            }
            byte[] byArray = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    public Response saveServiceRegistration(@PathParam(value="ServiceGroupId") String string, @PathParam(value="DocumentTypeId") String string2, ServiceMetadataType serviceMetadataType) throws Throwable {
        if (SMPServerConfiguration.isRESTWritableAPIDisabled()) {
            s_aLogger.warn("The writable REST API is disabled. saveServiceRegistration will not be executed.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        WebScopeManager.onRequestBegin((String)"public", (HttpServletRequest)this.m_aHttpRequest, (HttpServletResponse)new MockHttpServletResponse());
        try {
            if (new SMPServerAPI((ISMPServerAPIDataProvider)new SMPServerAPIDataProvider(this.m_aUriInfo)).saveServiceRegistration(string, string2, serviceMetadataType, RestRequestHelper.getAuth((HttpHeaders)this.m_aHttpHeaders)).isFailure()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response;
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public Response deleteServiceRegistration(@PathParam(value="ServiceGroupId") String string, @PathParam(value="DocumentTypeId") String string2) throws Throwable {
        if (SMPServerConfiguration.isRESTWritableAPIDisabled()) {
            s_aLogger.warn("The writable REST API is disabled. deleteServiceRegistration will not be executed.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        WebScopeManager.onRequestBegin((String)"public", (HttpServletRequest)this.m_aHttpRequest, (HttpServletResponse)new MockHttpServletResponse());
        try {
            if (new SMPServerAPI((ISMPServerAPIDataProvider)new SMPServerAPIDataProvider(this.m_aUriInfo)).deleteServiceRegistration(string, string2, RestRequestHelper.getAuth((HttpHeaders)this.m_aHttpHeaders)).isFailure()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response;
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }
}

