/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smpserver.servlet;

import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCA_MailTo;
import com.helger.html.hc.html.grouping.HCP;
import com.helger.html.hc.html.metadata.HCHead;
import com.helger.html.hc.html.metadata.HCStyle;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.html.sections.HCBody;
import com.helger.html.hc.html.sections.HCH1;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.render.HCRenderer;
import com.helger.peppol.smpserver.CSMPServer;
import com.helger.peppol.smpserver.SMPServerConfiguration;
import com.helger.peppol.smpserver.app.CApp;
import com.helger.peppol.smpserver.security.SMPKeyManager;
import com.helger.peppol.smpserver.smlhook.RegistrationHookFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SMPWebServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HCHtml hCHtml = new HCHtml();
        HCHead hCHead = hCHtml.getHead();
        hCHead.setPageTitle(CApp.getApplicationTitle());
        hCHead.addCSS((IHCNode)new HCStyle("*{font-family:sans-serif;}a,a:link,a:visited,a:hover,a:active{color:#109010}"));
        HCBody hCBody = hCHtml.getBody();
        hCBody.addChild((IHCNode)new HCH1().addChild(CApp.getApplicationTitle()));
        hCBody.addChild((IHCNode)new HCP().addChild("SMP-ID: " + SMPServerConfiguration.getSMLSMPID()));
        hCBody.addChild((IHCNode)new HCP().addChild("Version: " + CSMPServer.getVersionNumber()));
        if (!SMPKeyManager.isCertificateValid()) {
            hCBody.addChild((IHCNode)new HCP().addChild("Certificate configuration is invalid. REST queries will not work!"));
        }
        hCBody.addChild((IHCNode)new HCP().addChild("SML connection: " + (RegistrationHookFactory.isSMLConnectionActive() ? "active!" : "NOT active!")));
        hCBody.addChild((IHCNode)((HCP)((HCP)((HCP)((HCP)((HCP)((HCP)((HCP)new HCP().addStyle(CCSSProperties.BORDER_TOP.newValue("solid 1px black"))).addStyle(CCSSProperties.PADDING_TOP.newValue("1em"))).addChild("Created by ")).addChild((IHCNode)HCA_MailTo.createLinkedEmail((String)"philip@helger.com", (String)"Philip Helger"))).addChild(" - Twitter: ")).addChild((IHCNode)((HCA)new HCA((ISimpleURL)new SimpleURL("https://twitter.com/philiphelger")).setTargetBlank()).addChild("@philiphelger"))).addChild(" - ")).addChild((IHCNode)((HCA)new HCA((ISimpleURL)new SimpleURL("https://github.com/phax/peppol-smp-server")).setTargetBlank()).addChild("Source on GitHub")));
        String string = HCRenderer.getAsHTMLString((IHCNode)hCHtml);
        httpServletResponse.getWriter().write(string);
        httpServletResponse.getWriter().flush();
    }
}

