/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.testfiles;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public final class ErrorDefinition
implements Comparable<ErrorDefinition> {
    private final EErrorLevel m_eLevel;
    private final String m_sErrorCode;

    private ErrorDefinition(@Nonnull EErrorLevel eErrorLevel, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)eErrorLevel, (String)"Level");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ErrorCode");
        this.m_eLevel = eErrorLevel;
        this.m_sErrorCode = string;
    }

    @Nonnull
    public EErrorLevel getLevel() {
        return this.m_eLevel;
    }

    @Nonnull
    @Nonempty
    public String getErrorCode() {
        return this.m_sErrorCode;
    }

    @Override
    public int compareTo(@Nonnull ErrorDefinition errorDefinition) {
        int n = this.m_eLevel.compareTo((Enum)errorDefinition.m_eLevel);
        if (n == 0) {
            n = this.m_sErrorCode.compareTo(errorDefinition.m_sErrorCode);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ErrorDefinition errorDefinition = (ErrorDefinition)object;
        return this.m_eLevel.equals((Object)errorDefinition.m_eLevel) && this.m_sErrorCode.equals(errorDefinition.m_sErrorCode);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eLevel).append((Object)this.m_sErrorCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("level", (Enum)this.m_eLevel).append("errorCode", (Object)this.m_sErrorCode).toString();
    }

    @Nonnull
    public static ErrorDefinition createWarning(@Nonnull @Nonempty String string) {
        return new ErrorDefinition(EErrorLevel.WARN, string);
    }

    @Nonnull
    public static ErrorDefinition createError(@Nonnull @Nonempty String string) {
        return new ErrorDefinition(EErrorLevel.FATAL_ERROR, string);
    }
}

