/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.testfiles;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.testfiles.ErrorDefinition;
import javax.annotation.Nonnull;

public final class TestDocument {
    private final String m_sFilename;
    private final ICommonsSet<ErrorDefinition> m_aExpectedErrors = new CommonsHashSet();

    public TestDocument(@Nonnull @Nonempty String string, ErrorDefinition ... errorDefinitionArray) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        this.m_sFilename = string;
        if (errorDefinitionArray != null) {
            for (ErrorDefinition errorDefinition : errorDefinitionArray) {
                if (errorDefinition == null) continue;
                this.m_aExpectedErrors.add((Object)errorDefinition);
            }
        }
    }

    @Nonnull
    @Nonempty
    public String getFilename() {
        return this.m_sFilename;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<ErrorDefinition> getAllExpectedErrors() {
        return (ICommonsSet)this.m_aExpectedErrors.getClone();
    }

    public boolean hasExpectedErrors() {
        return this.m_aExpectedErrors.isNotEmpty();
    }

    public String toString() {
        return new ToStringGenerator(null).append("filename", (Object)this.m_sFilename).append("expectedErrors", this.m_aExpectedErrors).toString();
    }
}

