/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.testfiles;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.testfiles.ErrorDefinition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TestResource {
    private final IReadableResource m_aRes;
    private final ICommonsSet<ErrorDefinition> m_aExpectedErrors = new CommonsHashSet();

    public TestResource(@Nonnull IReadableResource iReadableResource, @Nullable ICommonsSet<ErrorDefinition> iCommonsSet) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_aRes = iReadableResource;
        if (iCommonsSet != null) {
            for (ErrorDefinition errorDefinition : iCommonsSet) {
                if (errorDefinition == null) continue;
                this.m_aExpectedErrors.add((Object)errorDefinition);
            }
        }
    }

    @Nonnull
    public IReadableResource getResource() {
        return this.m_aRes;
    }

    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_aRes.getPath();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<ErrorDefinition> getAllExpectedErrors() {
        return (ICommonsSet)this.m_aExpectedErrors.getClone();
    }

    public boolean hasExpectedErrors() {
        return this.m_aExpectedErrors.isNotEmpty();
    }

    public String toString() {
        return new ToStringGenerator(null).append("resource", (Object)this.m_aRes).append("expectedErrors", this.m_aExpectedErrors).toString();
    }

    @Nonnull
    public static TestResource createGoodCase(@Nonnull String string) {
        return new TestResource((IReadableResource)new ClassPathResource(string), null);
    }
}

