/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.testfiles;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public final class ErrorDefinition
implements Comparable<ErrorDefinition> {
    private final IErrorLevel m_aLevel;
    private final String m_sErrorCode;

    private ErrorDefinition(@Nonnull IErrorLevel iErrorLevel, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"Level");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ErrorCode");
        this.m_aLevel = iErrorLevel;
        this.m_sErrorCode = string;
    }

    @Nonnull
    public IErrorLevel getLevel() {
        return this.m_aLevel;
    }

    @Nonnull
    @Nonempty
    public String getErrorCode() {
        return this.m_sErrorCode;
    }

    @Override
    public int compareTo(@Nonnull ErrorDefinition errorDefinition) {
        int n = this.m_aLevel.getNumericLevel() - errorDefinition.m_aLevel.getNumericLevel();
        if (n == 0) {
            n = this.m_sErrorCode.compareTo(errorDefinition.m_sErrorCode);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ErrorDefinition errorDefinition = (ErrorDefinition)object;
        return this.m_aLevel.equals(errorDefinition.m_aLevel) && this.m_sErrorCode.equals(errorDefinition.m_sErrorCode);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLevel).append((Object)this.m_sErrorCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("level", (Object)this.m_aLevel).append("errorCode", (Object)this.m_sErrorCode).getToString();
    }

    @Nonnull
    public static ErrorDefinition createWarning(@Nonnull @Nonempty String string) {
        return new ErrorDefinition((IErrorLevel)EErrorLevel.WARN, string);
    }

    @Nonnull
    public static ErrorDefinition createError(@Nonnull @Nonempty String string) {
        return new ErrorDefinition((IErrorLevel)EErrorLevel.FATAL_ERROR, string);
    }
}

