/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.testfiles.official;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.ClassPathResource;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class OfficialTestFiles {
    private static final ICommonsList<ClassPathResource> CATALOGUE_01_T19 = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> CATALOGUE_01_T58 = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> ORDER_03_T01 = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> INVOICE_04_T10 = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> BILLING_05_T14 = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> ORDERING_28_T01 = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> ORDERING_28_T76 = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> DESPATCH_ADVICE_30_T16 = new CommonsArrayList();

    private OfficialTestFiles() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesCatalogue_01_T19() {
        return (ICommonsList)CATALOGUE_01_T19.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesCatalogue_01_T58() {
        return (ICommonsList)CATALOGUE_01_T58.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesOrder_03_T01() {
        return (ICommonsList)ORDER_03_T01.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesInvoice_04_T10() {
        return (ICommonsList)INVOICE_04_T10.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesBilling_05_T14() {
        return (ICommonsList)BILLING_05_T14.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesOrdering_28_T01() {
        return (ICommonsList)ORDERING_28_T01.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesOrdering_28_T76() {
        return (ICommonsList)ORDERING_28_T76.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllTestFilesDespatchAdvice_30_T16() {
        return (ICommonsList)DESPATCH_ADVICE_30_T16.getClone();
    }

    static {
        for (String string : new String[]{"Catalogue Use case 1.xml", "Catalogue Use case 2.xml", "Catalogue Use case 3.xml", "Catalogue Use case 4.xml", "Catalogue Use case 5.xml"}) {
            CATALOGUE_01_T19.add((Object)new ClassPathResource("/peppol-official/BIS01A/" + string));
        }
        for (String string : new String[]{"Catalogue Response use case 1 TP.xml", "Catalogue Response use case 2 TP.xml", "Catalogue Response use case 3 TP.xml", "Catalogue Response use case 4 TP.xml", "Catalogue Response use case 5 TP.xml"}) {
            CATALOGUE_01_T58.add((Object)new ClassPathResource("/peppol-official/BIS01A/" + string));
        }
        for (String string : new String[]{"UC1_Order.xml", "UC2_Order.xml", "UC3_Order.xml", "UC4_Order.xml"}) {
            ORDER_03_T01.add((Object)new ClassPathResource("/peppol-official/BIS03A/" + string));
        }
        for (String string : new String[]{"good-bis4a-zero-amount.xml", "Use Case 1.a_ExampleFile_PEPPOL BIS.xml", "Use Case 1.b_ExampleFile_PEPPOL BIS.xml", "Use Case 2_ExampleFile_PEPPOL BIS.xml", "Use Case 3_ExampleFile_PEPPOL BIS.xml", "Use Case 4_ExampleFile_PEPPOL BIS.xml", "Use Case 5_ExampleFile_PEPPOL BIS.xml"}) {
            INVOICE_04_T10.add((Object)new ClassPathResource("/peppol-official/BIS04A/" + string));
        }
        for (String string : new String[]{"good-bis5a-zero-amount.xml", "Use Case 1.a_CreditNote_PEPPOL BIS.xml", "Use Case 1.b_CreditNote_PEPPOL BIS.xml", "Use Case 2_CreditNote_PEPPOL BIS.xml", "Use Case 3_CreditNote_PEPPOL BIS.xml", "Use Case 4_CreditNote_PEPPOL BIS.xml", "Use Case 5_CreditNote_PEPPOL BIS.xml"}) {
            BILLING_05_T14.add((Object)new ClassPathResource("/peppol-official/BIS05A/" + string));
        }
        for (String string : new String[]{"UC1_Order.xml", "UC2_Order.xml", "UC3_Order.xml", "UC4_Order.xml"}) {
            ORDERING_28_T01.add((Object)new ClassPathResource("/peppol-official/BIS28A/" + string));
        }
        for (String string : new String[]{"UC1_Order_response.xml", "UC2_Order_response.xml", "UC3_Order_response.xml", "UC4_Order_response.xml"}) {
            ORDERING_28_T76.add((Object)new ClassPathResource("/peppol-official/BIS28A/" + string));
        }
        for (String string : new String[]{"UBL-DespatchAdvice-2_1BII2 openPEPPOL BIS_UseCase4.xml", "UBL-DespatchAdvice-2_1BII2 openPEPPOL BIS_UseCase5.xml", "UBL-DespatchAdvice-2.1BII2 openPEPPOL BIS_UseCase1.xml", "UBL-DespatchAdvice-2.1BII2 openPEPPOL BIS_UseCase2.xml", "UBL-DespatchAdvice-2.1BII2 openPEPPOL BIS_UseCase3.xml"}) {
            DESPATCH_ADVICE_30_T16.add((Object)new ClassPathResource("/peppol-official/BIS30A/" + string));
        }
    }
}

