/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.testfiles.sbdh;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.ClassPathResource;
import javax.annotation.Nonnull;

public final class PeppolSBDHTestFiles {
    private static final ICommonsList<ClassPathResource> GOOD_CASES = new CommonsArrayList();
    private static final ICommonsList<ClassPathResource> BAD_CASES = new CommonsArrayList();

    private PeppolSBDHTestFiles() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllGoodCases() {
        return (ICommonsList)GOOD_CASES.getClone();
    }

    @Nonnull
    public static ClassPathResource getFirstGoodCase() {
        return (ClassPathResource)GOOD_CASES.getFirst();
    }

    @Nonnull
    public static ClassPathResource getFirstGoodCaseV11() {
        return (ClassPathResource)GOOD_CASES.findFirst(classPathResource -> classPathResource.getPath().endsWith("good-v11.xml"));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ClassPathResource> getAllBadCases() {
        return (ICommonsList)BAD_CASES.getClone();
    }

    @Nonnull
    public static ClassPathResource getFirstBadCase() {
        return (ClassPathResource)BAD_CASES.getFirst();
    }

    static {
        for (String string : new String[]{"good.xml", "good-v11.xml", "good-additional-scopes.xml", "good-bis3.xml", "good-order-with-qty-ph.xml", "good-to-9915-test.xml", "good-type-version-20.xml"}) {
            GOOD_CASES.add((Object)new ClassPathResource("/sbdh/good/" + string));
        }
        for (String string : new String[]{"bad-no-xml.txt", "bad-no-sbdh.xml", "bad-invalid-header-version.xml", "bad-too-few-senders.xml", "bad-too-many-senders.xml", "bad-invalid-sender-authority.xml", "bad-invalid-sender-value.xml", "bad-too-few-receivers.xml", "bad-too-many-receivers.xml", "bad-invalid-receiver-authority.xml", "bad-invalid-receiver-value.xml", "bad-no-business-scope.xml", "bad-too-few-scopes.xml", "bad-invalid-document-type-identifier.xml", "bad-invalid-process-identifier.xml", "bad-no-document-type-identifier.xml", "bad-no-process-identifier.xml", "bad-no-business-message.xml", "bad-invalid-business-message.xml", "bad-invalid-standard.xml", "bad-invalid-type-version.xml", "bad-invalid-type.xml", "bad-invalid-instance-identifier.xml", "bad-invalid-creation-date-and-time.xml"}) {
            BAD_CASES.add((Object)new ClassPathResource("/sbdh/bad/" + string));
        }
    }
}

