/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.validation.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.validation.api.ValidationKey;
import com.helger.peppol.validation.api.artefact.IValidationArtefact;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ValidationConfiguration
implements Serializable {
    private final ValidationKey m_aValidationKey;
    private final ICommonsList<IValidationArtefact> m_aValidationArtefacts;

    public ValidationConfiguration(@Nonnull ValidationKey validationKey, @Nonnull @Nonempty List<IValidationArtefact> list) {
        ValueEnforcer.notNull((Object)validationKey, (String)"ValidationKey");
        ValueEnforcer.notEmptyNoNullValue(list, (String)"ValidationArtefacts");
        this.m_aValidationKey = validationKey;
        this.m_aValidationArtefacts = new CommonsArrayList(list);
    }

    @Nonnull
    public ValidationKey getValidationKey() {
        return this.m_aValidationKey;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<IValidationArtefact> getAllValidationArtefacts() {
        return (ICommonsList)this.m_aValidationArtefacts.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("extendedValidationKey", (Object)this.m_aValidationKey).append("validationArtefacts", this.m_aValidationArtefacts).toString();
    }
}

