/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.validation.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.validation.api.IBusinessSpecification;
import com.helger.peppol.validation.api.ISpecificationTransaction;
import com.helger.peppol.validation.api.ValidationSectorKey;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
@MustImplementEqualsAndHashcode
public class ValidationKey
implements Serializable,
Comparable<ValidationKey> {
    private final IBusinessSpecification m_aBusinessSpecification;
    private final ISpecificationTransaction m_aTransaction;
    private final Locale m_aCountry;
    private final ValidationSectorKey m_aSectorKey;
    private final String m_sPrerequisiteXPath;

    public ValidationKey(@Nonnull IBusinessSpecification iBusinessSpecification, @Nonnull ISpecificationTransaction iSpecificationTransaction, @Nullable String string, @Nullable ValidationSectorKey validationSectorKey, @Nullable String string2) {
        this.m_aBusinessSpecification = (IBusinessSpecification)ValueEnforcer.notNull((Object)iBusinessSpecification, (String)"BusinessSpecification");
        this.m_aTransaction = (ISpecificationTransaction)ValueEnforcer.notNull((Object)iSpecificationTransaction, (String)"Transaction");
        if (StringHelper.hasText((String)string)) {
            this.m_aCountry = CountryCache.getInstance().getCountry(string);
            if (this.m_aCountry == null) {
                throw new IllegalArgumentException("The passed country '" + string + "' does not exist!");
            }
        } else {
            this.m_aCountry = null;
        }
        this.m_aSectorKey = validationSectorKey;
        this.m_sPrerequisiteXPath = string2;
    }

    @Nonnull
    public IBusinessSpecification getBusinessSpecification() {
        return this.m_aBusinessSpecification;
    }

    @Nonnull
    public ISpecificationTransaction getTransaction() {
        return this.m_aTransaction;
    }

    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aTransaction.getUBLDocumentType().getImplementationClass();
    }

    public boolean isCountrySpecific() {
        return this.m_aCountry != null;
    }

    @Nullable
    public Locale getCountryLocale() {
        return this.m_aCountry;
    }

    @Nullable
    public String getCountryCode() {
        return this.m_aCountry == null ? null : this.m_aCountry.getCountry();
    }

    public boolean isSectorSpecific() {
        return this.m_aSectorKey != null;
    }

    @Nullable
    public ValidationSectorKey getSectorKey() {
        return this.m_aSectorKey;
    }

    public boolean hasPrerequisiteXPath() {
        return StringHelper.hasText((String)this.m_sPrerequisiteXPath);
    }

    @Nullable
    public String getPrerequisiteXPath() {
        return this.m_sPrerequisiteXPath;
    }

    public boolean hasSameSpecificationAndTransaction(@Nullable ValidationKey validationKey) {
        if (validationKey == null) {
            return false;
        }
        return this.m_aBusinessSpecification.equals(validationKey.m_aBusinessSpecification) && this.m_aTransaction.equals(validationKey.m_aTransaction);
    }

    public boolean hasSameSpecificationAndTransactionAndCountryAndSector(@Nullable ValidationKey validationKey) {
        if (validationKey == null) {
            return false;
        }
        return this.m_aBusinessSpecification.equals(validationKey.m_aBusinessSpecification) && this.m_aTransaction.equals(validationKey.m_aTransaction) && EqualsHelper.equals((Object)this.m_aCountry, (Object)validationKey.m_aCountry) && (EqualsHelper.equals((Object)this.m_aSectorKey, (Object)validationKey.m_aSectorKey) || this.m_aSectorKey == null && validationKey.m_aSectorKey != null);
    }

    @Override
    public int compareTo(@Nonnull ValidationKey validationKey) {
        int n = CompareHelper.compare((int)this.m_aBusinessSpecification.getNumber(), (int)validationKey.m_aBusinessSpecification.getNumber());
        if (n == 0 && (n = this.m_aTransaction.getTransactionKey().compareTo(validationKey.m_aTransaction.getTransactionKey())) == 0 && (n = CompareHelper.compare((Comparable)((Object)this.getCountryCode()), (Comparable)((Object)validationKey.getCountryCode()))) == 0 && (n = CompareHelper.compare((Comparable)this.m_aSectorKey, (Comparable)this.m_aSectorKey)) == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.m_sPrerequisiteXPath), (Comparable)((Object)validationKey.m_sPrerequisiteXPath));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationKey validationKey = (ValidationKey)object;
        return this.m_aBusinessSpecification.equals(validationKey.m_aBusinessSpecification) && this.m_aTransaction.equals(validationKey.m_aTransaction) && EqualsHelper.equals((Object)this.m_aCountry, (Object)validationKey.m_aCountry) && EqualsHelper.equals((Object)this.m_aSectorKey, (Object)validationKey.m_aSectorKey) && EqualsHelper.equals((Object)this.m_sPrerequisiteXPath, (Object)validationKey.m_sPrerequisiteXPath);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aBusinessSpecification).append((Object)this.m_aTransaction).append((Object)this.m_aCountry).append((Object)this.m_aSectorKey).append((Object)this.m_sPrerequisiteXPath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BusinessSpecification", (Object)this.m_aBusinessSpecification).append("Transaction", (Object)this.m_aTransaction).append("Country", (Object)this.m_aCountry).append("SectorKey", (Object)this.m_aSectorKey).append("PrerequisiteXPath", (Object)this.m_sPrerequisiteXPath).toString();
    }

    @NotThreadSafe
    public static class Builder {
        private IBusinessSpecification m_aBusinessSpecification;
        private ISpecificationTransaction m_aTransaction;
        private String m_sCountry;
        private ValidationSectorKey m_aSectorKey;
        private String m_sPrerequisiteXPath;

        public Builder() {
        }

        public Builder(@Nonnull ValidationKey validationKey) {
            this.m_aBusinessSpecification = validationKey.m_aBusinessSpecification;
            this.m_aTransaction = validationKey.m_aTransaction;
            this.m_sCountry = validationKey.getCountryCode();
            this.m_aSectorKey = validationKey.m_aSectorKey;
            this.m_sPrerequisiteXPath = validationKey.m_sPrerequisiteXPath;
        }

        @Nonnull
        public Builder setBusinessSpecification(@Nullable IBusinessSpecification iBusinessSpecification) {
            this.m_aBusinessSpecification = iBusinessSpecification;
            return this;
        }

        @Nonnull
        public Builder setTransaction(@Nullable ISpecificationTransaction iSpecificationTransaction) {
            this.m_aTransaction = iSpecificationTransaction;
            return this;
        }

        @Nonnull
        public Builder setCountry(@Nullable String string) {
            this.m_sCountry = string;
            return this;
        }

        @Nonnull
        public Builder setSectorKey(@Nullable ValidationSectorKey validationSectorKey) {
            this.m_aSectorKey = validationSectorKey;
            return this;
        }

        @Nonnull
        public Builder setPrerequisiteXPath(@Nullable String string) {
            this.m_sPrerequisiteXPath = string;
            return this;
        }

        @Nonnull
        public ValidationKey build() {
            if (this.m_aBusinessSpecification == null) {
                throw new IllegalStateException("The Business specification must be provided");
            }
            if (this.m_aTransaction == null) {
                throw new IllegalStateException("The Transaction must be provided");
            }
            return new ValidationKey(this.m_aBusinessSpecification, this.m_aTransaction, this.m_sCountry, this.m_aSectorKey, this.m_sPrerequisiteXPath);
        }
    }
}

