/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.validation.api.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.peppol.validation.api.ISpecificationProfile;
import com.helger.peppol.validation.api.ISpecificationTransaction;
import com.helger.peppol.validation.api.peppol.EBII2Group;
import com.helger.peppol.validation.api.peppol.EBII2ProfileName;
import com.helger.peppol.validation.api.peppol.EBII2Transaction;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EBII2Profile implements ISpecificationProfile
{
    BII_MLR(EBII2ProfileName.BII_MLR, 0, EBII2Transaction.T71),
    BII01(EBII2ProfileName.BII01, 1, EBII2Transaction.T19, EBII2Transaction.T58),
    BII02(EBII2ProfileName.BII02, 2, EBII2Transaction.T20, EBII2Transaction.T21, EBII2Transaction.T59),
    BII03(EBII2ProfileName.BII03, 3, EBII2Transaction.T01),
    BII04(EBII2ProfileName.BII04, 4, EBII2Transaction.T10),
    BII05(EBII2ProfileName.BII05, 5, EBII2Transaction.T10, EBII2Transaction.T14),
    BII06(EBII2ProfileName.BII06, 6, EBII2Transaction.T01, EBII2Transaction.T02, EBII2Transaction.T10, EBII2Transaction.T14),
    BII10(EBII2ProfileName.BII10, 10, EBII2Transaction.T64A, EBII2Transaction.T64B, EBII2Transaction.T64C, EBII2Transaction.T65),
    BII11(EBII2ProfileName.BII11, 11, EBII2Transaction.T41, EBII2Transaction.T42),
    BII12(EBII2ProfileName.BII12, 12, EBII2Transaction.T44, EBII2Transaction.T45),
    BII16(EBII2ProfileName.BII16, 16, EBII2Transaction.T22, EBII2Transaction.T23),
    BII17(EBII2ProfileName.BII17, 17, EBII2Transaction.T18, EBII2Transaction.T54, EBII2Transaction.T55),
    BII21(EBII2ProfileName.BII21, 21, EBII2Transaction.T26),
    BII22(EBII2ProfileName.BII22, 22, EBII2Transaction.T40),
    BII27(EBII2ProfileName.BII27, 27, EBII2Transaction.T01, EBII2Transaction.T02, EBII2Transaction.T04, EBII2Transaction.T05),
    BII28(EBII2ProfileName.BII28, 28, EBII2Transaction.T01, EBII2Transaction.T76),
    BII30(EBII2ProfileName.BII30, 30, EBII2Transaction.T16),
    BII31(EBII2ProfileName.BII31, 31, EBII2Transaction.T17),
    BII32(EBII2ProfileName.BII32, 32, EBII2Transaction.T01, EBII2Transaction.T02),
    BII33(EBII2ProfileName.BII33, 33, EBII2Transaction.T72, EBII2Transaction.T73),
    BII34(EBII2ProfileName.BII34, 34, EBII2Transaction.T40, EBII2Transaction.T69),
    BII35(EBII2ProfileName.BII35, 35, EBII2Transaction.T44, EBII2Transaction.T68, EBII2Transaction.T45);

    private final IHasDisplayText m_aName;
    private final int m_nNumber;
    private final EBII2Group m_eGroup;
    private final ICommonsOrderedSet<EBII2Transaction> m_aTransactions;

    private void _checkTransactionsSameGroup() {
        for (EBII2Transaction eBII2Transaction : this.m_aTransactions) {
            if (eBII2Transaction.getGroup() == this.m_eGroup) continue;
            throw new IllegalStateException("Different groups in transactions for " + this.toString());
        }
    }

    private EBII2Profile(@Nonnull @Nonempty EBII2ProfileName eBII2ProfileName, int n2, EBII2Transaction ... eBII2TransactionArray) {
        this.m_aName = eBII2ProfileName;
        this.m_nNumber = n2;
        this.m_eGroup = eBII2TransactionArray[0].getGroup();
        this.m_aTransactions = CollectionHelper.newOrderedSet((Object[])eBII2TransactionArray);
        if (GlobalDebug.isDebugMode()) {
            this._checkTransactionsSameGroup();
        }
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName.getDisplayText(locale);
    }

    @Override
    @Nonnegative
    public int getNumber() {
        return this.m_nNumber;
    }

    @Override
    @Nonnull
    public EBII2Group getGroup() {
        return this.m_eGroup;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<EBII2Transaction> getAllTransactions() {
        return this.m_aTransactions.getCopyAsList();
    }

    @Override
    public boolean containsTransaction(@Nullable ISpecificationTransaction iSpecificationTransaction) {
        return this.m_aTransactions.contains((Object)iSpecificationTransaction);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<EBII2Profile> getAllProfilesWithTransaction(@Nonnull EBII2Transaction eBII2Transaction) {
        ValueEnforcer.notNull((Object)eBII2Transaction, (String)"Transaction");
        return EnumHelper.getAll(EBII2Profile.class, eBII2Profile -> eBII2Profile.containsTransaction(eBII2Transaction));
    }
}

