/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.validation.api.peppol;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.validation.api.ISpecificationTransaction;
import com.helger.peppol.validation.api.peppol.EBII2Group;
import com.helger.ubl21.EUBL21DocumentType;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EBII2Transaction implements ISpecificationTransaction
{
    T01("Order", 1, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.ORDER),
    T02("Simple Order Response", 2, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.ORDER_RESPONSE_SIMPLE),
    T04("Counter Offer", 4, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.ORDER_RESPONSE),
    T05("Simple Counter Offer Response", 5, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.ORDER_CHANGE),
    T10("Invoice", 10, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.INVOICE),
    T14("Credit Note", 14, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.CREDIT_NOTE),
    T16("Dispatch Advice", 16, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.DESPATCH_ADVICE),
    T17("Reminder", 17, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.REMINDER),
    T18("Catalogue Request", 18, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.CATALOGUE_REQUEST),
    T19("Catalogue", 19, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.CATALOGUE),
    T20("Catalogue Item Update", 20, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.CATALOGUE_ITEM_SPECIFICATION_UPDATE),
    T21("Catalogue Price Update", 21, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.CATALOGUE_PRICING_UPDATE),
    T22("Catalogue Delete Request", 22, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.CATALOGUE_DELETION),
    T23("Catalogue Delete Confirmation", 23, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.APPLICATION_RESPONSE),
    T26("Statement", 26, null, "2.0", EBII2Group.POST_AWARD, EUBL21DocumentType.STATEMENT),
    T40("Call for Tender", 40, null, "1.0", EBII2Group.TENDERING, EUBL21DocumentType.CALL_FOR_TENDERS),
    T41("Qualification", 41, null, "1.0", EBII2Group.TENDERING, EUBL21DocumentType.TENDER_QUALIFICATION),
    T42("Qualification Reception Notification", 42, null, "1.0", EBII2Group.TENDERING, EUBL21DocumentType.TENDER_QUALIFICATION_RESPONSE),
    T44("Tender", 44, null, "1.0", EBII2Group.TENDERING, EUBL21DocumentType.TENDER),
    T45("Tender Reception Notification", 45, null, "1.0", EBII2Group.TENDERING, EUBL21DocumentType.TENDER_RECEIPT),
    T54("Multi Party Catalogue", 54, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.CATALOGUE),
    T55("Catalogue Request Rejection", 55, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.APPLICATION_RESPONSE),
    T58("Catalogue Response", 58, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.APPLICATION_RESPONSE),
    T59("Catalogue Update Response", 59, null, "2.0", EBII2Group.CATALOGUE, EUBL21DocumentType.APPLICATION_RESPONSE),
    T64A("Prior Information Notice", 64, "A", "1.0", EBII2Group.NOTIFICATION, EUBL21DocumentType.PRIOR_INFORMATION_NOTICE),
    T64B("Contract  Notice", 64, "B", "1.0", EBII2Group.NOTIFICATION, EUBL21DocumentType.CONTRACT_NOTICE),
    T64C("Contract Award Notice", 64, "C", "1.0", EBII2Group.NOTIFICATION, EUBL21DocumentType.CONTRACT_AWARD_NOTICE),
    T65("Notice Publication Response", 65, null, "1.0", EBII2Group.NOTIFICATION, EUBL21DocumentType.APPLICATION_RESPONSE),
    T68("Pre-award Catalogue", 68, null, "1.0", EBII2Group.TENDERING, EUBL21DocumentType.CATALOGUE),
    T69("Pre-award Catalogue Template", 69, null, "1.0", EBII2Group.TENDERING, EUBL21DocumentType.CATALOGUE),
    T71("Message Level Response", 71, null, "1.0", EBII2Group.ARCHITECTURE, EUBL21DocumentType.APPLICATION_RESPONSE),
    T72("Catalogue Subscription Request", 72, null, "1.0", EBII2Group.CATALOGUE, EUBL21DocumentType.CATALOGUE_REQUEST),
    T73("Catalogue Subscription Response", 73, null, "1.0", EBII2Group.CATALOGUE, EUBL21DocumentType.APPLICATION_RESPONSE),
    T76("Order Response", 76, null, "1.0", EBII2Group.POST_AWARD, EUBL21DocumentType.ORDER_RESPONSE);

    private final String m_sID = this.name();
    private final String m_sName;
    private final int m_nNumber;
    private final String m_sSubNumber;
    private final String m_sVersion;
    private final String m_sTransactionID;
    private final EBII2Group m_eGroup;
    private final EUBL21DocumentType m_eUBLDocumentType;

    private EBII2Transaction(@Nullable String string2, @Nonnull @Nonempty int n2, @Nonnull String string3, @Nonnull String string4, EBII2Group eBII2Group, EUBL21DocumentType eUBL21DocumentType) {
        this.m_sName = string2;
        this.m_nNumber = n2;
        this.m_sSubNumber = StringHelper.getNotNull((String)string3, (String)"");
        this.m_sVersion = string4;
        this.m_sTransactionID = "urn:www.cenbii.eu:transaction:biitrns" + StringHelper.getLeadingZero((int)n2, (int)3) + this.m_sSubNumber + ":ver" + string4;
        this.m_eGroup = eBII2Group;
        this.m_eUBLDocumentType = eUBL21DocumentType;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnegative
    public int getNumber() {
        return this.m_nNumber;
    }

    @Override
    @Nonnull
    public String getSubNumber() {
        return this.m_sSubNumber;
    }

    @Override
    @Nonnull
    public EBII2Group getGroup() {
        return this.m_eGroup;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getTransactionID() {
        return this.m_sTransactionID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getTransactionKey() {
        return "T" + StringHelper.getLeadingZero((int)this.m_nNumber, (int)3) + this.m_sSubNumber;
    }

    @Nonnull
    @Nonempty
    public String getTransactionKeyShort() {
        return "T" + StringHelper.getLeadingZero((int)this.m_nNumber, (int)2) + this.m_sSubNumber;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getVersionNumber() {
        return this.m_sVersion;
    }

    @Override
    @Nonnull
    public EUBL21DocumentType getUBLDocumentType() {
        return this.m_eUBLDocumentType;
    }

    @Nullable
    public static EBII2Transaction getFromIDOrNull(@Nullable String string) {
        return (EBII2Transaction)EnumHelper.getFromIDOrNull(EBII2Transaction.class, (Object)string);
    }
}

