/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.validation.api.peppol;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.peppol.validation.api.IBusinessSpecification;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPeppolBIS implements IBusinessSpecification
{
    CATALOGUE_01("OpenPEPPOL BIS 1, Catalogue", 1),
    ORDER_03("OpenPEPPOL BIS 3, Order", 3),
    INVOICE_04("OpenPEPPOL BIS 4, Invoice", 4),
    BILLING_05("OpenPEPPOL BIS 5, Billing", 5),
    ORDERING_28("OpenPEPPOL BIS 28, Ordering", 28),
    DESPATCH_ADVICE_30("OpenPEPPOL BIS 30, Despatch advice", 30),
    MLR_36("OpenPEPPOL BIS 36, MLR", 36);

    private final String m_sDisplayName;
    private final int m_nNumber;

    private EPeppolBIS(String string2, int n2) {
        this.m_sDisplayName = string2;
        this.m_nNumber = n2;
    }

    @Override
    public int getNumber() {
        return this.m_nNumber;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return "openpeppol-bis-" + this.m_nNumber;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nullable
    public static EPeppolBIS getFromIDOrNull(@Nullable String string) {
        return (EPeppolBIS)EnumHelper.getFromIDOrNull(EPeppolBIS.class, (Object)string);
    }
}

