/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.validation.api.result;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.state.ETriState;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.validation.api.artefact.IValidationArtefact;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class ValidationLayerResult
implements ISuccessIndicator,
Serializable {
    private final IValidationArtefact m_aValidationArtefact;
    private final IErrorList m_aResourceErrors;
    private final ETriState m_eSuccess;

    public ValidationLayerResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull IError iError) {
        this(iValidationArtefact, (IErrorList)new ErrorList(new IError[]{iError}));
    }

    public ValidationLayerResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull Iterable<? extends IError> iterable) {
        this(iValidationArtefact, (IErrorList)new ErrorList(iterable));
    }

    public ValidationLayerResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull IErrorList iErrorList) {
        this(iValidationArtefact, iErrorList, ETriState.valueOf((boolean)iErrorList.containsNoFailure()));
    }

    private ValidationLayerResult(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull IErrorList iErrorList, @Nonnull ETriState eTriState) {
        this.m_aValidationArtefact = (IValidationArtefact)ValueEnforcer.notNull((Object)iValidationArtefact, (String)"ValidationArtefact");
        this.m_aResourceErrors = (IErrorList)ValueEnforcer.notNull((Object)iErrorList, (String)"ResourceErrors");
        this.m_eSuccess = (ETriState)ValueEnforcer.notNull((Object)eTriState, (String)"Success");
    }

    @Nonnull
    public IValidationArtefact getValidationArtefact() {
        return this.m_aValidationArtefact;
    }

    @Nonnull
    public IErrorList getResourceErrorGroup() {
        return this.m_aResourceErrors;
    }

    public boolean isSuccess() {
        return this.m_eSuccess.isTrue();
    }

    public boolean isFailure() {
        return this.m_eSuccess.isFalse();
    }

    public boolean isIgnored() {
        return this.m_eSuccess.isUndefined();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ValidationArtefact", (Object)this.m_aValidationArtefact).append("ResourceErrors", (Object)this.m_aResourceErrors).append("Success", (Enum)this.m_eSuccess).toString();
    }

    @Nonnull
    public static ValidationLayerResult createIgnoredLayer(@Nonnull IValidationArtefact iValidationArtefact) {
        return new ValidationLayerResult(iValidationArtefact, (IErrorList)new ErrorList(), ETriState.UNDEFINED);
    }
}

