/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.validation.api.result;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsIterable;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.validation.api.result.ValidationLayerResult;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ValidationLayerResultList
implements ICommonsIterable<ValidationLayerResult>,
Serializable {
    private final ICommonsList<ValidationLayerResult> m_aList = new CommonsArrayList();

    public void add(@Nonnull ValidationLayerResult validationLayerResult) {
        ValueEnforcer.notNull((Object)validationLayerResult, (String)"ValidationLayerResult");
        this.m_aList.add((Object)validationLayerResult);
    }

    public void add(@Nonnegative int n, @Nonnull ValidationLayerResult validationLayerResult) {
        ValueEnforcer.notNull((Object)validationLayerResult, (String)"ValidationLayerResult");
        this.m_aList.add(n, (Object)validationLayerResult);
    }

    public void addAll(@Nonnull ValidationLayerResultList validationLayerResultList) {
        ValueEnforcer.notNull((Object)validationLayerResultList, (String)"ValidationLayerResultList");
        this.m_aList.addAll(validationLayerResultList.m_aList);
    }

    @Nonnegative
    public int getSize() {
        return this.m_aList.size();
    }

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ValidationLayerResult> getAll() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Nonnull
    public Iterator<ValidationLayerResult> iterator() {
        return this.m_aList.iterator();
    }

    public boolean containsNoFailure() {
        for (ValidationLayerResult validationLayerResult : this.m_aList) {
            if (validationLayerResult.getResourceErrorGroup().containsNoFailure()) continue;
            return false;
        }
        return true;
    }

    public boolean containsNoError() {
        for (ValidationLayerResult validationLayerResult : this.m_aList) {
            if (validationLayerResult.getResourceErrorGroup().containsNoError()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAtLeastOneFailure() {
        for (ValidationLayerResult validationLayerResult : this.m_aList) {
            if (!validationLayerResult.getResourceErrorGroup().containsAtLeastOneFailure()) continue;
            return true;
        }
        return false;
    }

    public boolean containsAtLeastOneError() {
        for (ValidationLayerResult validationLayerResult : this.m_aList) {
            if (!validationLayerResult.getResourceErrorGroup().containsAtLeastOneError()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllFailures() {
        ErrorList errorList = new ErrorList();
        for (ValidationLayerResult validationLayerResult : this.m_aList) {
            errorList.addAll((Iterable)validationLayerResult.getResourceErrorGroup().getAllFailures());
        }
        return errorList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getAllErrors() {
        ErrorList errorList = new ErrorList();
        for (ValidationLayerResult validationLayerResult : this.m_aList) {
            errorList.addAll((Iterable)validationLayerResult.getResourceErrorGroup().getAllErrors());
        }
        return errorList;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("List", this.m_aList).toString();
    }
}

