/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet;

import com.helger.as4.attachment.EAS4CompressionMode;
import com.helger.as4.attachment.IIncomingAttachmentFactory;
import com.helger.as4.attachment.WSS4JAttachment;
import com.helger.as4.client.BasicHttpPoster;
import com.helger.as4.crypto.AS4CryptoFactory;
import com.helger.as4.crypto.ECryptoAlgorithmSign;
import com.helger.as4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.as4.error.EEbmsError;
import com.helger.as4.http.AS4HttpDebug;
import com.helger.as4.http.HttpMimeMessageEntity;
import com.helger.as4.http.HttpXMLEntity;
import com.helger.as4.messaging.domain.AS4ErrorMessage;
import com.helger.as4.messaging.domain.AS4ReceiptMessage;
import com.helger.as4.messaging.domain.AS4UserMessage;
import com.helger.as4.messaging.domain.EAS4MessageType;
import com.helger.as4.messaging.domain.MessageHelperMethods;
import com.helger.as4.messaging.encrypt.EncryptionCreator;
import com.helger.as4.messaging.mime.MimeMessageCreator;
import com.helger.as4.messaging.sign.SignedMessageCreator;
import com.helger.as4.mgr.MetaAS4Manager;
import com.helger.as4.model.EMEP;
import com.helger.as4.model.EMEPBinding;
import com.helger.as4.model.MEPHelper;
import com.helger.as4.model.pmode.IPMode;
import com.helger.as4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.as4.model.pmode.leg.PModeLeg;
import com.helger.as4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.as4.model.pmode.leg.PModeLegSecurity;
import com.helger.as4.profile.IAS4Profile;
import com.helger.as4.servlet.AS4MessageState;
import com.helger.as4.servlet.AS4Response;
import com.helger.as4.servlet.AS4WorkerPool;
import com.helger.as4.servlet.BadRequestException;
import com.helger.as4.servlet.IAS4MessageState;
import com.helger.as4.servlet.mgr.AS4ServerConfiguration;
import com.helger.as4.servlet.mgr.AS4ServerSettings;
import com.helger.as4.servlet.mgr.AS4ServletMessageProcessorManager;
import com.helger.as4.servlet.soap.AS4SingleSOAPHeader;
import com.helger.as4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.as4.servlet.soap.SOAPHeaderElementProcessorRegistry;
import com.helger.as4.servlet.spi.AS4MessageProcessorResult;
import com.helger.as4.servlet.spi.AS4SignalMessageProcessorResult;
import com.helger.as4.servlet.spi.IAS4ServletMessageProcessorSPI;
import com.helger.as4.soap.ESOAPVersion;
import com.helger.as4.util.AS4ResourceManager;
import com.helger.as4.util.AS4XMLHelper;
import com.helger.as4lib.ebms3header.Ebms3CollaborationInfo;
import com.helger.as4lib.ebms3header.Ebms3Error;
import com.helger.as4lib.ebms3header.Ebms3MessageInfo;
import com.helger.as4lib.ebms3header.Ebms3MessageProperties;
import com.helger.as4lib.ebms3header.Ebms3PartInfo;
import com.helger.as4lib.ebms3header.Ebms3PartyInfo;
import com.helger.as4lib.ebms3header.Ebms3PayloadInfo;
import com.helger.as4lib.ebms3header.Ebms3Property;
import com.helger.as4lib.ebms3header.Ebms3SignalMessage;
import com.helger.as4lib.ebms3header.Ebms3UserMessage;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.httpclient.response.ResponseHandlerXml;
import com.helger.web.multipart.MultipartProgressNotifier;
import com.helger.web.multipart.MultipartStream;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class AS4Handler
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4Handler.class);
    private static final IMimeType MT_MULTIPART_RELATED = EMimeContentType.MULTIPART.buildMimeType("related");
    private static final AtomicBoolean s_aDebug = new AtomicBoolean(false);
    private final AS4ResourceManager m_aResMgr = new AS4ResourceManager();
    private Locale m_aLocale = CGlobal.DEFAULT_LOCALE;
    private final AS4CryptoFactory m_aCryptoFactory = AS4CryptoFactory.DEFAULT_INSTANCE;

    public static boolean isDebug() {
        return s_aDebug.get();
    }

    public static void setDebug(boolean bl) {
        s_aDebug.set(bl);
    }

    @Override
    public void close() {
        this.m_aResMgr.close();
    }

    @Nonnull
    public Locale getLocale() {
        return this.m_aLocale;
    }

    @Nonnull
    public AS4Handler setLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        this.m_aLocale = locale;
        return this;
    }

    private static void _decompressAttachments(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList) {
        for (WSS4JAttachment wSS4JAttachment : (ICommonsList)iCommonsList.getClone()) {
            Ebms3Property ebms3Property2;
            EAS4CompressionMode eAS4CompressionMode = iAS4MessageState.getAttachmentCompressionMode(wSS4JAttachment.getId());
            if (eAS4CompressionMode == null) continue;
            IHasInputStream iHasInputStream = wSS4JAttachment.getInputStreamProvider();
            wSS4JAttachment.setSourceStreamProvider((IHasInputStream)new HasInputStream((ISupplier & Serializable)() -> {
                try {
                    return eAS4CompressionMode.getDecompressStream(iHasInputStream.getInputStream());
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }, iHasInputStream.isReadMultiple()));
            String string = StringHelper.trimStart((String)wSS4JAttachment.getId(), (String)"attachment=");
            Ebms3PartInfo ebms3PartInfo2 = (Ebms3PartInfo)CollectionHelper.findFirst((Iterable)ebms3UserMessage.getPayloadInfo().getPartInfo(), ebms3PartInfo -> ebms3PartInfo.getHref() != null && ebms3PartInfo.getHref().contains(string));
            if (ebms3PartInfo2 == null || (ebms3Property2 = (Ebms3Property)CollectionHelper.findFirst((Iterable)ebms3PartInfo2.getPartProperties().getProperty(), ebms3Property -> ebms3Property.getName().equals("MimeType"))) == null) continue;
            wSS4JAttachment.overwriteMimeType(ebms3Property2.getValue());
        }
    }

    private void _processSOAPHeaderElements(@Nonnull Document document, @Nonnull ESOAPVersion eSOAPVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws BadRequestException {
        Object object;
        Object object2;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Element element = XMLHelper.getFirstChildElementOfName((Node)document.getDocumentElement(), (String)eSOAPVersion.getNamespaceURI(), (String)eSOAPVersion.getHeaderElementName());
        if (element == null) {
            throw new BadRequestException("SOAP document is missing a Header element");
        }
        for (Object object3 : new ChildElementIterator((Node)element)) {
            object2 = XMLHelper.getQName((Element)object3);
            object = object3.getAttributeNS(eSOAPVersion.getNamespaceURI(), "mustUnderstand");
            boolean bl = eSOAPVersion.getMustUnderstandValue(true).equals(object);
            commonsArrayList.add((Object)new AS4SingleSOAPHeader((Element)object3, (QName)object2, bl));
        }
        for (Object object4 : SOAPHeaderElementProcessorRegistry.getInstance().getAllElementProcessors().entrySet()) {
            Object object3;
            object3 = (QName)object4.getKey();
            object2 = (AS4SingleSOAPHeader)commonsArrayList.findFirst(arg_0 -> AS4Handler.lambda$_processSOAPHeaderElements$2((QName)object3, arg_0));
            if (object2 == null) {
                if (!AS4Handler.isDebug()) continue;
                LOGGER.info("Message contains no SOAP header element with QName " + ((QName)object3).toString());
                continue;
            }
            object = (ISOAPHeaderElementProcessor)object4.getValue();
            if (AS4Handler.isDebug()) {
                LOGGER.info("Processing SOAP header element " + ((QName)object3).toString() + " with processor " + object);
            }
            ErrorList errorList = new ErrorList();
            if (object.processHeaderElement(document, ((AS4SingleSOAPHeader)object2).getNode(), iCommonsList, aS4MessageState, errorList, this.m_aLocale).isSuccess()) {
                ((AS4SingleSOAPHeader)object2).setProcessed(true);
                continue;
            }
            LOGGER.warn("Failed to process SOAP header element " + ((QName)object3).toString() + " with processor " + object + "; error details: " + errorList);
            String string = aS4MessageState.getRefToMessageID();
            for (IError iError : errorList) {
                EEbmsError eEbmsError = EEbmsError.getFromErrorCodeOrNull((String)iError.getErrorID());
                if (eEbmsError != null) {
                    iCommonsList2.add((Object)eEbmsError.getAsEbms3Error(this.m_aLocale, string));
                    continue;
                }
                Ebms3Error ebms3Error = new Ebms3Error();
                ebms3Error.setErrorDetail(iError.getErrorText(this.m_aLocale));
                ebms3Error.setErrorCode(iError.getErrorID());
                ebms3Error.setSeverity((String)iError.getErrorLevel().getID());
                ebms3Error.setOrigin(iError.getErrorFieldName());
                ebms3Error.setRefToMessageInError(string);
                iCommonsList2.add((Object)ebms3Error);
            }
        }
        if (iCommonsList2.isEmpty()) {
            for (Object object4 : commonsArrayList) {
                if (!((AS4SingleSOAPHeader)object4).isMustUnderstand() || ((AS4SingleSOAPHeader)object4).isProcessed()) continue;
                throw new BadRequestException("Error processing required SOAP header element " + ((AS4SingleSOAPHeader)object4).getQName().toString());
            }
        }
    }

    private void _invokeSPIs(@Nullable Ebms3UserMessage ebms3UserMessage, @Nullable Ebms3SignalMessage ebms3SignalMessage, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList3, @Nullable IPMode iPMode, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull SPIInvocationResult sPIInvocationResult) {
        ValueEnforcer.isTrue((ebms3UserMessage != null || ebms3SignalMessage != null ? 1 : 0) != 0, (String)"User OR Signal Message must be present");
        ValueEnforcer.isFalse((ebms3UserMessage != null && ebms3SignalMessage != null ? 1 : 0) != 0, (String)"Only one of User OR Signal Message may be present");
        boolean bl = ebms3UserMessage != null;
        String string = bl ? ebms3UserMessage.getMessageInfo().getMessageId() : ebms3SignalMessage.getMessageInfo().getMessageId();
        for (IAS4ServletMessageProcessorSPI iAS4ServletMessageProcessorSPI : AS4ServletMessageProcessorManager.getAllProcessors()) {
            try {
                String string2;
                AS4MessageProcessorResult aS4MessageProcessorResult;
                if (AS4Handler.isDebug()) {
                    LOGGER.info("Invoking AS4 message processor " + iAS4ServletMessageProcessorSPI);
                }
                if ((aS4MessageProcessorResult = bl ? iAS4ServletMessageProcessorSPI.processAS4UserMessage(ebms3UserMessage, iPMode, node, iCommonsList, iAS4MessageState) : iAS4ServletMessageProcessorSPI.processAS4SignalMessage(ebms3SignalMessage, iPMode, iAS4MessageState)) == null) {
                    throw new IllegalStateException("No result object present from AS4 SPI processor " + iAS4ServletMessageProcessorSPI);
                }
                if (aS4MessageProcessorResult.isFailure()) {
                    string2 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' returned a failure: " + aS4MessageProcessorResult.getErrorMessage();
                    LOGGER.warn(string2);
                    iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(this.m_aLocale, string, string2));
                    return;
                }
                string2 = aS4MessageProcessorResult.getAsyncResponseURL();
                if (StringHelper.hasText((String)string2)) {
                    if (sPIInvocationResult.hasAsyncResponseURL()) {
                        String string3 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' failed: the previous processor already returned an async response URL; it is not possible to handle two URLs. Please check your SPI implementations.";
                        LOGGER.warn(string3);
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsEbms3Error(this.m_aLocale, string, string3));
                        return;
                    }
                    sPIInvocationResult.setAsyncResponseURL(string2);
                }
                if (!bl && ebms3SignalMessage.getReceipt() == null) {
                    string2 = ((AS4SignalMessageProcessorResult)aS4MessageProcessorResult).getPullReturnUserMessage();
                    if (sPIInvocationResult.hasPullReturnUserMsg()) {
                        if (string2 != null) {
                            String string4 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' failed: the previous processor already returned a usermessage; it is not possible to return two usermessage. Please check your SPI implementations.";
                            LOGGER.warn(string4);
                            iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsEbms3Error(this.m_aLocale, string, string4));
                            return;
                        }
                    } else {
                        if (string2 == null) {
                            String string5 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' returned a failure: no UserMessage contained in the MPC";
                            LOGGER.warn(string5);
                            iCommonsList2.add((Object)EEbmsError.EBMS_EMPTY_MESSAGE_PARTITION_CHANNEL.getAsEbms3Error(this.m_aLocale, string, string5));
                            return;
                        }
                        sPIInvocationResult.setPullReturnUserMsg((Ebms3UserMessage)string2);
                    }
                }
                aS4MessageProcessorResult.addAllAttachmentsTo((Collection<WSS4JAttachment>)iCommonsList3);
                if (!AS4Handler.isDebug()) continue;
                LOGGER.info("Successfully invoked AS4 message processor " + iAS4ServletMessageProcessorSPI);
            }
            catch (Throwable throwable) {
                if (throwable.getCause() instanceof ZipException) {
                    iCommonsList2.add((Object)EEbmsError.EBMS_DECOMPRESSION_FAILURE.getAsEbms3Error(this.m_aLocale, string));
                    return;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new IllegalStateException("Error processing incoming AS4 message with processor " + iAS4ServletMessageProcessorSPI, throwable);
            }
        }
        sPIInvocationResult.setSuccess(true);
    }

    @Nullable
    private IAS4ResponseFactory _handleSOAPMessage(@Nonnull Document document, @Nonnull ESOAPVersion eSOAPVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList) throws WSSecurityException, MessagingException {
        Object object;
        AS4ErrorMessage aS4ErrorMessage;
        SPIInvocationResult sPIInvocationResult;
        ValueEnforcer.notNull((Object)document, (String)"SOAPDocument");
        ValueEnforcer.notNull((Object)eSOAPVersion, (String)"SOAPVersion");
        ValueEnforcer.notNull(iCommonsList, (String)"IncomingAttachments");
        if (AS4Handler.isDebug()) {
            LOGGER.info("Received the following SOAP " + eSOAPVersion.getVersion() + " document:");
            LOGGER.info(AS4XMLHelper.serializeXML((Node)document));
            LOGGER.info("Including the following " + iCommonsList.size() + " attachments:");
            LOGGER.info(iCommonsList.toString());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        AS4MessageState aS4MessageState = new AS4MessageState(eSOAPVersion, this.m_aResMgr);
        this._processSOAPHeaderElements(document, eSOAPVersion, iCommonsList, aS4MessageState, (ICommonsList<Ebms3Error>)commonsArrayList);
        AS4MessageState aS4MessageState2 = aS4MessageState;
        aS4MessageState = aS4MessageState2.getPMode();
        PModeLeg pModeLeg = aS4MessageState2.getEffectivePModeLeg();
        boolean bl = aS4MessageState2.getEffectivePModeLegNumber() == 1;
        Ebms3UserMessage ebms3UserMessage = null;
        Ebms3SignalMessage ebms3SignalMessage = null;
        Ebms3Error ebms3Error = null;
        Node node = null;
        ICommonsList<WSS4JAttachment> iCommonsList2 = null;
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        if (commonsArrayList.isEmpty()) {
            boolean bl3;
            Element element;
            ebms3UserMessage = aS4MessageState2.getMessaging().hasUserMessageEntries() ? aS4MessageState2.getMessaging().getUserMessageAtIndex(0) : null;
            int n = (ebms3UserMessage != null ? 1 : 0) + ((sPIInvocationResult = (ebms3SignalMessage = aS4MessageState2.getMessaging().hasSignalMessageEntries() ? aS4MessageState2.getMessaging().getSignalMessageAtIndex(0) : null) != null ? ebms3SignalMessage.getPullRequest() : null) != null ? 1 : 0) + ((aS4ErrorMessage = ebms3SignalMessage != null ? ebms3SignalMessage.getReceipt() : null) != null ? 1 : 0) + ((ebms3Error = ebms3SignalMessage != null && !ebms3SignalMessage.getError().isEmpty() ? ebms3SignalMessage.getErrorAtIndex(0) : null) != null ? 1 : 0);
            if (n != 1) {
                commonsArrayList.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.getAsEbms3Error(this.m_aLocale, aS4MessageState2.getRefToMessageID()));
            }
            if (AS4Handler.isDebug() && aS4ErrorMessage != null) {
                LOGGER.info("RECEIPT INCOMING");
            }
            ICommonsList<WSS4JAttachment> iCommonsList3 = iCommonsList2 = aS4MessageState2.hasDecryptedAttachments() ? aS4MessageState2.getDecryptedAttachments() : aS4MessageState2.getOriginalAttachments();
            if (ebms3UserMessage != null) {
                if (aS4MessageState == null) {
                    throw new BadRequestException("No AS4 P-Mode configuration found for user-message!");
                }
                if (pModeLeg == null) {
                    throw new BadRequestException("No AS4 P-Mode leg could be determined!");
                }
                string2 = AS4ServerConfiguration.getAS4ProfileID();
                if (StringHelper.hasText((String)string2)) {
                    IAS4Profile iAS4Profile = MetaAS4Manager.getProfileMgr().getProfileOfID(string2);
                    if (iAS4Profile == null) {
                        throw new IllegalStateException("The configured AS4 profile " + string2 + " does not exist.");
                    }
                    object = iAS4Profile.getValidator();
                    if (object != null) {
                        element = new ErrorList();
                        object.validatePMode((IPMode)aS4MessageState, (ErrorList)element);
                        object.validateUserMessage(ebms3UserMessage, (ErrorList)element);
                        if (element.isNotEmpty()) {
                            throw new BadRequestException("Error validating incoming AS4 message with the profile " + iAS4Profile.getDisplayName() + "\n Following errors are present: " + element.getAllErrors().getAllTexts(this.m_aLocale));
                        }
                    }
                }
                string = ebms3UserMessage.getMessageInfo().getMessageId();
                AS4Handler._decompressAttachments(ebms3UserMessage, aS4MessageState2, iCommonsList2);
            } else {
                if (sPIInvocationResult != null && aS4MessageState == null) {
                    throw new BadRequestException("No AS4 P-Mode configuration found for pull-request!");
                }
                string = ebms3SignalMessage.getMessageInfo().getMessageId();
            }
            boolean bl4 = aS4MessageState2.hasDecryptedSOAPDocument();
            Document document2 = object = bl4 ? aS4MessageState2.getDecryptedSOAPDocument() : document;
            assert (object != null);
            element = XMLHelper.getFirstChildElementOfName((Node)object.getDocumentElement(), (String)eSOAPVersion.getNamespaceURI(), (String)eSOAPVersion.getBodyElementName());
            if (element == null) {
                throw new BadRequestException((bl4 ? "Decrypted" : "Original") + " SOAP document is missing a Body element");
            }
            node = element.getFirstChild();
            if (ebms3UserMessage != null) {
                if (ebms3UserMessage.getMessageProperties() == null) {
                    throw new BadRequestException("No Message Properties present but OriginalSender and finalRecipient have to be present");
                }
                List list = ebms3UserMessage.getMessageProperties().getProperty();
                if (list.isEmpty()) {
                    throw new BadRequestException("Message Property element present but no properties");
                }
                AS4Handler._checkPropertiesOrignalSenderAndFinalRecipient(list);
            }
            if (bl3 = MetaAS4Manager.getIncomingDuplicateMgr().registerAndCheck(string, string2, aS4MessageState == null ? null : (String)aS4MessageState.getID()).isBreak()) {
                LOGGER.info("Not invoking SPIs, because message was already handled!");
                commonsArrayList.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(this.m_aLocale, string, "Another message with the same ID was already received!"));
            } else if (AS4Handler._isNotPingMessage((IPMode)aS4MessageState)) {
                bl2 = true;
            }
        }
        sPIInvocationResult = new SPIInvocationResult();
        if (bl2) {
            if (aS4MessageState == null || aS4MessageState.getMEPBinding().isSynchronous() || aS4MessageState.getMEPBinding().isAsynchronousInitiator() || !bl) {
                this._invokeSPIs(ebms3UserMessage, ebms3SignalMessage, node, iCommonsList2, (ICommonsList<Ebms3Error>)commonsArrayList, (ICommonsList<WSS4JAttachment>)commonsArrayList2, (IPMode)aS4MessageState, aS4MessageState2, sPIInvocationResult);
                if (sPIInvocationResult.isFailure()) {
                    LOGGER.warn("Error invoking synchronous SPIs");
                } else if (AS4Handler.isDebug()) {
                    LOGGER.info("Successfully invoked synchronous SPIs");
                }
            } else {
                aS4ErrorMessage = ebms3UserMessage;
                Ebms3SignalMessage ebms3SignalMessage2 = ebms3SignalMessage;
                Node node2 = node;
                object = iCommonsList2;
                AS4WorkerPool.getInstance().run((IThrowingRunnable<? extends Throwable>)((IThrowingRunnable & Serializable)() -> this.lambda$_handleSOAPMessage$2f468e11$1((Ebms3UserMessage)aS4ErrorMessage, ebms3SignalMessage2, node2, object, (IPMode)aS4MessageState, aS4MessageState2, eSOAPVersion, (ICommonsList)commonsArrayList2, pModeLeg)));
            }
        }
        if (ebms3Error == null) {
            if (commonsArrayList.isNotEmpty()) {
                if (AS4Handler._isSendErrorAsResponse(pModeLeg)) {
                    aS4ErrorMessage = AS4ErrorMessage.create((ESOAPVersion)eSOAPVersion, (ICommonsList)commonsArrayList);
                    return new AS4ResponseFactoryXML(aS4ErrorMessage.getAsSOAPDocument());
                }
                LOGGER.warn("Not sending back the error, because sending error response is prohibited in PMode");
            } else if (ebms3SignalMessage == null || ebms3SignalMessage.getReceipt() == null) {
                if (aS4MessageState.getMEP().isOneWay() || aS4MessageState.getMEPBinding().isAsynchronous()) {
                    if (aS4MessageState.getMEPBinding().equals((Object)EMEPBinding.PULL) || aS4MessageState.getMEPBinding().equals((Object)EMEPBinding.PULL_PUSH) && sPIInvocationResult.hasPullReturnUserMsg() || aS4MessageState.getMEPBinding().equals((Object)EMEPBinding.PUSH_PULL) && sPIInvocationResult.hasPullReturnUserMsg()) {
                        return new AS4ResponseFactoryXML(new AS4UserMessage(eSOAPVersion, sPIInvocationResult.getPullReturnUserMsg()).getAsSOAPDocument());
                    }
                    if (ebms3UserMessage != null) {
                        boolean bl5 = AS4Handler._isSendReceiptAsResponse(pModeLeg);
                        if (bl5) {
                            return this._createReceiptMessage(document, eSOAPVersion, pModeLeg, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList2);
                        }
                        LOGGER.info("Not sending back the receipt response, because sending receipt response is prohibited in PMode");
                    }
                } else {
                    aS4ErrorMessage = aS4MessageState.getLeg2();
                    if (aS4ErrorMessage == null) {
                        throw new BadRequestException("PMode has no leg2!");
                    }
                    if (MEPHelper.isValidResponseTypeLeg2((EMEP)aS4MessageState.getMEP(), (EMEPBinding)aS4MessageState.getMEPBinding(), (EAS4MessageType)EAS4MessageType.USER_MESSAGE)) {
                        AS4UserMessage aS4UserMessage = AS4Handler._createReversedUserMessage(eSOAPVersion, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList2);
                        return this._createResponseUserMessage((ICommonsList<WSS4JAttachment>)commonsArrayList2, (PModeLeg)aS4ErrorMessage, aS4UserMessage.getAsSOAPDocument(), aS4UserMessage.getMessagingID());
                    }
                }
            }
        }
        return null;
    }

    private IAS4ResponseFactory _createReceiptMessage(@Nullable Document document, @Nonnull ESOAPVersion eSOAPVersion, @Nonnull PModeLeg pModeLeg, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable ICommonsList<WSS4JAttachment> iCommonsList) throws WSSecurityException {
        AS4ReceiptMessage aS4ReceiptMessage = (AS4ReceiptMessage)AS4ReceiptMessage.create((ESOAPVersion)eSOAPVersion, (String)MessageHelperMethods.createRandomMessageID(), (Ebms3UserMessage)ebms3UserMessage, (Node)document, (boolean)AS4Handler._isSendNonRepudiationInformation(pModeLeg)).setMustUnderstand(true);
        Document document2 = aS4ReceiptMessage.getAsSOAPDocument();
        document2 = this._signResponseIfNeeded(iCommonsList, pModeLeg.getSecurity(), document2, pModeLeg.getProtocol().getSOAPVersion(), aS4ReceiptMessage.getMessagingID());
        return new AS4ResponseFactoryXML(document2);
    }

    @Nonnull
    private static AS4UserMessage _createReversedUserMessage(@Nonnull ESOAPVersion eSOAPVersion, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList) {
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo((String)MessageHelperMethods.createRandomMessageID(), (String)ebms3UserMessage.getMessageInfo().getMessageId());
        Ebms3PayloadInfo ebms3PayloadInfo = MessageHelperMethods.createEbms3PayloadInfo((boolean)false, iCommonsList);
        Ebms3PartyInfo ebms3PartyInfo = MessageHelperMethods.createEbms3ReversePartyInfo((Ebms3PartyInfo)ebms3UserMessage.getPartyInfo());
        Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
        Ebms3MessageProperties ebms3MessageProperties = new Ebms3MessageProperties();
        Ebms3Property ebms3Property = null;
        Ebms3Property ebms3Property2 = null;
        for (Ebms3Property ebms3Property3 : ebms3UserMessage.getMessageProperties().getProperty()) {
            if (ebms3Property3.getName().equals("finalRecipient")) {
                ebms3Property2 = ebms3Property3;
                continue;
            }
            if (!ebms3Property3.getName().equals("originalSender")) continue;
            ebms3Property = ebms3Property3;
        }
        if (ebms3Property2 == null) {
            throw new IllegalStateException("Failed to determine new OriginalSender");
        }
        if (ebms3Property == null) {
            throw new IllegalStateException("Failed to determine new FinalRecipient");
        }
        ebms3Property.setName("originalSender");
        ebms3Property2.setName("finalRecipient");
        ebms3MessageProperties.addProperty(ebms3Property);
        ebms3MessageProperties.addProperty(ebms3Property2);
        ebms3Property = AS4UserMessage.create((Ebms3MessageInfo)ebms3MessageInfo, (Ebms3PayloadInfo)ebms3PayloadInfo, (Ebms3CollaborationInfo)ebms3CollaborationInfo, (Ebms3PartyInfo)ebms3PartyInfo, (Ebms3MessageProperties)ebms3MessageProperties, (ESOAPVersion)eSOAPVersion);
        return ebms3Property;
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseUserMessage(@Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull PModeLeg pModeLeg, @Nonnull Document document, @Nonnull @Nonempty String string) throws WSSecurityException, MessagingException {
        Document document2 = pModeLeg.getSecurity() != null ? this._signResponseIfNeeded(iCommonsList, pModeLeg.getSecurity(), document, pModeLeg.getProtocol().getSOAPVersion(), string) : document;
        if (iCommonsList.isEmpty()) {
            return new AS4ResponseFactoryXML(document2);
        }
        MimeMessage mimeMessage = this._generateMimeMessageForResponse(iCommonsList, pModeLeg, document2);
        return new AS4ResponseFactoryMIME(mimeMessage);
    }

    private Document _signResponseIfNeeded(@Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull PModeLegSecurity pModeLegSecurity, @Nonnull Document document, @Nonnull ESOAPVersion eSOAPVersion, @Nonnull @Nonempty String string) throws WSSecurityException {
        if (pModeLegSecurity.getX509SignatureAlgorithm() != null && pModeLegSecurity.getX509SignatureHashFunction() != null) {
            return SignedMessageCreator.createSignedMessage((AS4CryptoFactory)this.m_aCryptoFactory, (Document)document, (ESOAPVersion)eSOAPVersion, (String)string, iCommonsList, (AS4ResourceManager)this.m_aResMgr, (boolean)true, (ECryptoAlgorithmSign)pModeLegSecurity.getX509SignatureAlgorithm(), (ECryptoAlgorithmSignDigest)pModeLegSecurity.getX509SignatureHashFunction());
        }
        return document;
    }

    @Nonnull
    private MimeMessage _generateMimeMessageForResponse(@Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull PModeLeg pModeLeg, @Nonnull Document document) throws WSSecurityException, MessagingException {
        MimeMessage mimeMessage = null;
        if (pModeLeg.getSecurity() != null && pModeLeg.getSecurity().getX509EncryptionAlgorithm() != null) {
            EncryptionCreator encryptionCreator = new EncryptionCreator(this.m_aCryptoFactory);
            mimeMessage = encryptionCreator.encryptMimeMessage(pModeLeg.getProtocol().getSOAPVersion(), document, true, iCommonsList, this.m_aResMgr, pModeLeg.getSecurity().getX509EncryptionAlgorithm());
        } else {
            mimeMessage = MimeMessageCreator.generateMimeMessage((ESOAPVersion)pModeLeg.getProtocol().getSOAPVersion(), (Document)document, iCommonsList);
        }
        if (mimeMessage == null) {
            throw new IllegalStateException("No MimeMessage created!");
        }
        return mimeMessage;
    }

    private static boolean _isNotPingMessage(@Nonnull IPMode iPMode) {
        PModeLegBusinessInformation pModeLegBusinessInformation;
        return iPMode == null || (pModeLegBusinessInformation = iPMode.getLeg1().getBusinessInfo()) == null || !"http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test".equals(pModeLegBusinessInformation.getAction()) || !"http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service".equals(pModeLegBusinessInformation.getService());
    }

    private static boolean _isSendNonRepudiationInformation(@Nonnull PModeLeg pModeLeg) {
        if (pModeLeg.getSecurity() != null && pModeLeg.getSecurity().isSendReceiptNonRepudiationDefined()) {
            return pModeLeg.getSecurity().isSendReceiptNonRepudiation();
        }
        return false;
    }

    private static boolean _isSendErrorAsResponse(@Nullable PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.getErrorHandling() != null && pModeLeg.getErrorHandling().isReportAsResponseDefined()) {
            return pModeLeg.getErrorHandling().isReportAsResponse();
        }
        return true;
    }

    private static boolean _isSendReceiptAsResponse(@Nonnull PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.getSecurity() != null) {
            return EPModeSendReceiptReplyPattern.RESPONSE.equals((Object)pModeLeg.getSecurity().getSendReceiptReplyPattern());
        }
        return true;
    }

    private static void _checkPropertiesOrignalSenderAndFinalRecipient(@Nonnull List<Ebms3Property> list) throws BadRequestException {
        String string = null;
        String string2 = null;
        for (Ebms3Property ebms3Property : list) {
            if (ebms3Property.getName().equals("originalSender")) {
                string = ebms3Property.getValue();
                continue;
            }
            if (!ebms3Property.getName().equals("finalRecipient")) continue;
            string2 = ebms3Property.getValue();
        }
        if (StringHelper.hasNoText(string)) {
            throw new BadRequestException("originalSender property is empty or not existant but mandatory");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new BadRequestException("finalRecipient property is empty or not existant but mandatory");
        }
    }

    @Nonnull
    private static InputStream _getRequestIS(@Nonnull HttpServletRequest httpServletRequest) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        return servletInputStream;
    }

    @Nonnull
    private static Document _readXML(@Nonnull InputStream inputStream) {
        if (AS4Handler.isDebug()) {
            byte[] byArray = StreamHelper.getAllBytes((InputStream)inputStream);
            Charset charset = Charset.defaultCharset();
            LOGGER.info("GOT[" + charset.name() + "]:\n" + new String(byArray, charset));
            return DOMReader.readXMLDOM((byte[])byArray);
        }
        return DOMReader.readXMLDOM((InputStream)inputStream);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull AS4Response aS4Response) throws BadRequestException, IOException, MessagingException, WSSecurityException {
        Object object;
        AS4HttpDebug.debug(() -> "RECEIVE-START at " + iRequestWebScopeWithoutResponse.getFullContextAndServletPath());
        HttpServletRequest httpServletRequest = iRequestWebScopeWithoutResponse.getRequest();
        String string = httpServletRequest.getContentType();
        if (StringHelper.hasNoText((String)string)) {
            throw new BadRequestException("Content-Type header is missing");
        }
        MimeType mimeType = MimeTypeParser.parseMimeType((String)string);
        if (AS4Handler.isDebug()) {
            LOGGER.info("Received Content-Type: " + mimeType);
        }
        if (mimeType == null) {
            throw new BadRequestException("Failed to parse Content-Type '" + string + "'");
        }
        Document document = null;
        ESOAPVersion eSOAPVersion = null;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        MimeType mimeType2 = mimeType.getCopyWithoutParameters();
        if (mimeType2.equals(MT_MULTIPART_RELATED)) {
            if (AS4Handler.isDebug()) {
                LOGGER.info("Received MIME message");
            }
            if (StringHelper.hasNoText((String)(object = mimeType.getParameterValueWithName("boundary")))) {
                throw new BadRequestException("Content-Type '" + string + "' misses boundary parameter");
            }
            if (AS4Handler.isDebug()) {
                LOGGER.info("MIME Boundary = " + (String)object);
            }
            MultipartStream multipartStream = new MultipartStream(AS4Handler._getRequestIS(httpServletRequest), ((String)object).getBytes(StandardCharsets.ISO_8859_1), (MultipartProgressNotifier)null);
            IIncomingAttachmentFactory iIncomingAttachmentFactory = AS4ServerSettings.getIncomingAttachmentFactory();
            int n = 0;
            while (true) {
                boolean bl;
                boolean bl2 = bl = n == 0 ? multipartStream.skipPreamble() : multipartStream.readBoundary();
                if (bl) {
                    MimeType mimeType3;
                    if (AS4Handler.isDebug()) {
                        LOGGER.info("Found MIME part " + n);
                    }
                    MultipartStream.MultipartItemInputStream multipartItemInputStream = multipartStream.createInputStream();
                    MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)multipartItemInputStream);
                    if (n == 0) {
                        mimeType3 = MimeTypeParser.parseMimeType((String)mimeBodyPart.getContentType()).getCopyWithoutParameters();
                        eSOAPVersion = (ESOAPVersion)ArrayHelper.findFirst((Object[])ESOAPVersion.values(), arg_0 -> AS4Handler.lambda$handleRequest$5((IMimeType)mimeType3, arg_0));
                        document = AS4Handler._readXML(mimeBodyPart.getInputStream());
                    } else {
                        mimeType3 = iIncomingAttachmentFactory.createAttachment(mimeBodyPart, this.m_aResMgr);
                        commonsArrayList.add((Object)mimeType3);
                    }
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            if (AS4Handler.isDebug()) {
                LOGGER.info("Received plain message with Content-Type " + mimeType.getAsString());
            }
            if ((document = AS4Handler._readXML(AS4Handler._getRequestIS(httpServletRequest))) != null) {
                eSOAPVersion = ESOAPVersion.getFromNamespaceURIOrNull((String)document.getDocumentElement().getNamespaceURI());
            }
            if (eSOAPVersion == null) {
                eSOAPVersion = ESOAPVersion.getFromMimeTypeOrNull((IMimeType)mimeType2);
            }
        }
        if (document == null) {
            throw new BadRequestException(eSOAPVersion == null ? "Failed to parse incoming message!" : "Failed to parse incoming SOAP " + eSOAPVersion.getVersion() + " document!");
        }
        if (eSOAPVersion == null) {
            object = XMLHelper.getNamespaceURI((Node)document);
            eSOAPVersion = (ESOAPVersion)ArrayHelper.findFirst((Object[])ESOAPVersion.values(), arg_0 -> AS4Handler.lambda$handleRequest$6((String)object, arg_0));
            if (eSOAPVersion == null) {
                throw new BadRequestException("Failed to determine SOAP version from XML document!");
            }
        }
        if ((object = this._handleSOAPMessage(document, eSOAPVersion, (ICommonsList<WSS4JAttachment>)commonsArrayList)) != null) {
            object.applyToResponse(eSOAPVersion, aS4Response);
        } else {
            aS4Response.setStatus(204);
        }
        AS4HttpDebug.debug(() -> AS4Handler.lambda$handleRequest$7((IAS4ResponseFactory)object));
    }

    private static /* synthetic */ String lambda$handleRequest$7(IAS4ResponseFactory iAS4ResponseFactory) {
        return "RECEIVE-END with " + (iAS4ResponseFactory != null ? "EBMS message" : "no content");
    }

    private static /* synthetic */ boolean lambda$handleRequest$6(String string, ESOAPVersion eSOAPVersion) {
        return eSOAPVersion.getNamespaceURI().equals(string);
    }

    private static /* synthetic */ boolean lambda$handleRequest$5(IMimeType iMimeType, ESOAPVersion eSOAPVersion) {
        return iMimeType.equals(eSOAPVersion.getMimeType());
    }

    private /* synthetic */ void lambda$_handleSOAPMessage$2f468e11$1(Ebms3UserMessage ebms3UserMessage, Ebms3SignalMessage ebms3SignalMessage, Node node, ICommonsList iCommonsList, IPMode iPMode, IAS4MessageState iAS4MessageState, ESOAPVersion eSOAPVersion, ICommonsList iCommonsList2, PModeLeg pModeLeg) throws Throwable {
        IAS4ResponseFactory iAS4ResponseFactory;
        Object object;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        SPIInvocationResult sPIInvocationResult = new SPIInvocationResult();
        this._invokeSPIs(ebms3UserMessage, ebms3SignalMessage, node, (ICommonsList<WSS4JAttachment>)iCommonsList, (ICommonsList<Ebms3Error>)commonsArrayList, (ICommonsList<WSS4JAttachment>)commonsArrayList2, iPMode, iAS4MessageState, sPIInvocationResult);
        if (sPIInvocationResult.isSuccess()) {
            assert (commonsArrayList.isEmpty());
            object = AS4Handler._createReversedUserMessage(eSOAPVersion, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList2);
            iAS4ResponseFactory = this._createResponseUserMessage((ICommonsList<WSS4JAttachment>)iCommonsList2, pModeLeg, object.getAsSOAPDocument(), object.getMessagingID());
        } else {
            object = AS4ErrorMessage.create((ESOAPVersion)eSOAPVersion, (ICommonsList)commonsArrayList);
            iAS4ResponseFactory = new AS4ResponseFactoryXML(object.getAsSOAPDocument());
        }
        object = sPIInvocationResult.getAsyncResponseURL();
        if (StringHelper.hasNoText((String)object)) {
            throw new IllegalStateException("No asynchronous response URL present!");
        }
        if (AS4Handler.isDebug()) {
            LOGGER.info("Responding asynchronous to: " + (String)object);
        }
        BasicHttpPoster basicHttpPoster = new BasicHttpPoster();
        Document document = (Document)basicHttpPoster.sendGenericMessage((String)object, iAS4ResponseFactory.getHttpEntity(eSOAPVersion), (ResponseHandler)new ResponseHandlerXml());
        AS4HttpDebug.debug(() -> "SEND-RESPONSE [async sent] received: " + XMLWriter.getNodeAsString((Node)document, (IXMLWriterSettings)AS4HttpDebug.getDebugXMLWriterSettings()));
    }

    private static /* synthetic */ boolean lambda$_processSOAPHeaderElements$2(QName qName, AS4SingleSOAPHeader aS4SingleSOAPHeader) {
        return qName.equals(aS4SingleSOAPHeader.getQName());
    }

    private static final class SPIInvocationResult
    implements ISuccessIndicator {
        private boolean m_bSuccess = false;
        private Ebms3UserMessage m_aPullReturnUserMsg;
        private String m_sAsyncResponseURL;

        private SPIInvocationResult() {
        }

        public boolean isSuccess() {
            return this.m_bSuccess;
        }

        void setSuccess(boolean bl) {
            this.m_bSuccess = bl;
        }

        void setPullReturnUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage) {
            this.m_aPullReturnUserMsg = ebms3UserMessage;
        }

        @Nullable
        public Ebms3UserMessage getPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg;
        }

        public boolean hasPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg != null;
        }

        void setAsyncResponseURL(@Nonnull String string) {
            this.m_sAsyncResponseURL = string;
        }

        @Nullable
        public String getAsyncResponseURL() {
            return this.m_sAsyncResponseURL;
        }

        public boolean hasAsyncResponseURL() {
            return StringHelper.hasText((String)this.m_sAsyncResponseURL);
        }
    }

    private static final class AS4ResponseFactoryMIME
    implements IAS4ResponseFactory {
        private final MimeMessage m_aMimeMsg;
        private final HttpHeaderMap m_aHeaders = new HttpHeaderMap();

        public AS4ResponseFactoryMIME(@Nonnull MimeMessage mimeMessage) throws MessagingException {
            this.m_aMimeMsg = mimeMessage;
            Enumeration enumeration = this.m_aMimeMsg.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                this.m_aHeaders.addHeader(header.getName(), HttpHeaderMap.getUnifiedValue((String)header.getValue()));
            }
            for (Header header : CollectionHelper.newList((Enumeration)this.m_aMimeMsg.getAllHeaders())) {
                this.m_aMimeMsg.removeHeader(header.getName());
            }
        }

        @Override
        public void applyToResponse(@Nonnull ESOAPVersion eSOAPVersion, @Nonnull AS4Response aS4Response) {
            aS4Response.addCustomResponseHeaders(this.m_aHeaders);
            aS4Response.setContent((IHasInputStream)HasInputStream.multiple((ISupplier & Serializable)() -> {
                try {
                    return this.m_aMimeMsg.getInputStream();
                }
                catch (IOException | MessagingException throwable) {
                    throw new IllegalStateException("Failed to get MIME input stream", throwable);
                }
            }));
            aS4Response.setMimeType(MT_MULTIPART_RELATED);
        }

        @Nonnull
        public HttpMimeMessageEntity getHttpEntity(@Nonnull ESOAPVersion eSOAPVersion) {
            return new HttpMimeMessageEntity(this.m_aMimeMsg);
        }
    }

    private static final class AS4ResponseFactoryXML
    implements IAS4ResponseFactory {
        private final Document m_aDoc;

        public AS4ResponseFactoryXML(@Nonnull Document document) {
            this.m_aDoc = document;
        }

        @Override
        public void applyToResponse(@Nonnull ESOAPVersion eSOAPVersion, @Nonnull AS4Response aS4Response) {
            String string = AS4XMLHelper.serializeXML((Node)this.m_aDoc);
            aS4Response.setContentAndCharset(string, AS4XMLHelper.XWS.getCharset()).setMimeType(eSOAPVersion.getMimeType());
        }

        @Override
        @Nonnull
        public HttpEntity getHttpEntity(@Nonnull ESOAPVersion eSOAPVersion) {
            return new HttpXMLEntity((Node)this.m_aDoc, eSOAPVersion);
        }
    }

    private static interface IAS4ResponseFactory {
        public void applyToResponse(@Nonnull ESOAPVersion var1, @Nonnull AS4Response var2);

        @Nonnull
        public HttpEntity getHttpEntity(@Nonnull ESOAPVersion var1);
    }
}

