/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet;

import com.helger.as4.attachment.EAS4CompressionMode;
import com.helger.as4.attachment.WSS4JAttachment;
import com.helger.as4.model.mpc.IMPC;
import com.helger.as4.model.pmode.IPMode;
import com.helger.as4.model.pmode.leg.PModeLeg;
import com.helger.as4.servlet.IAS4MessageState;
import com.helger.as4.soap.ESOAPVersion;
import com.helger.as4.util.AS4ResourceManager;
import com.helger.as4lib.ebms3header.Ebms3Messaging;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.attr.AttributeContainerAny;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.PDTFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Document;

@NotThreadSafe
public class AS4MessageState
extends AttributeContainerAny<String>
implements IAS4MessageState {
    private static final String KEY_EBMS3_MESSAGING = "as4.ebms3.messaging";
    private static final String KEY_PMODE = "as4.pmode.config";
    private static final String KEY_MPC = "as4.mpc";
    private static final String KEY_ORIGINAL_ATTACHMENT_LIST = "as4.soap.attachmentlist";
    private static final String KEY_DECRYPTED_SOAP_DOCUMENT = "as4.soap.decrypted.document";
    private static final String KEY_DECRYPTED_ATTACHMENT_LIST = "as4.soap.decrypted.attachmentlist";
    private static final String KEY_COMPRESSED_ATTACHMENT_IDS = "as4.compressed.attachment.ids";
    private static final String KEY_SOAP_BODY_PAYLOAD_PRESENT = "as4.soap.body.payload.present";
    private static final String KEY_INITIATOR_ID = "as4.initiator.id";
    private static final String KEY_RESPONDER_ID = "as4.responder.id";
    private static final String KEY_USED_CERTIFICATE = "as4.used.certificate";
    private static final String KEY_EFFECTIVE_PMODE_LEG = "as4.pmode.effective.leg";
    private static final String KEY_EFFECTIVE_PMODE_LEG_NUMBER = "as4.pmode.effective.leg.number";
    private static final String KEY_SOAP_CHECKED_SIGNATURE = "as4.soap.signature.checked";
    private static final String KEY_SOAP_DECRYPTED = "as4.soap.decrypted";
    private final LocalDateTime m_aReceiptDT = PDTFactory.getCurrentLocalDateTime();
    private final ESOAPVersion m_eSOAPVersion;
    private final AS4ResourceManager m_aResMgr;

    public AS4MessageState(@Nonnull ESOAPVersion eSOAPVersion, @Nonnull AS4ResourceManager aS4ResourceManager) {
        this.m_eSOAPVersion = (ESOAPVersion)ValueEnforcer.notNull((Object)eSOAPVersion, (String)"SOAPVersion");
        this.m_aResMgr = (AS4ResourceManager)ValueEnforcer.notNull((Object)aS4ResourceManager, (String)"ResMgr");
    }

    @Override
    @Nonnull
    public final LocalDateTime getReceiptDT() {
        return this.m_aReceiptDT;
    }

    @Override
    @Nonnull
    public final ESOAPVersion getSOAPVersion() {
        return this.m_eSOAPVersion;
    }

    @Override
    @Nonnull
    public final AS4ResourceManager getResourceMgr() {
        return this.m_aResMgr;
    }

    public void setMessaging(@Nullable Ebms3Messaging ebms3Messaging) {
        this.putIn(KEY_EBMS3_MESSAGING, ebms3Messaging);
    }

    @Override
    @Nullable
    public Ebms3Messaging getMessaging() {
        return (Ebms3Messaging)this.getCastedValue(KEY_EBMS3_MESSAGING);
    }

    public void setPMode(@Nullable IPMode iPMode) {
        this.putIn(KEY_PMODE, iPMode);
    }

    @Override
    @Nullable
    public IPMode getPMode() {
        return (IPMode)this.getCastedValue(KEY_PMODE);
    }

    public void setOriginalAttachments(@Nullable ICommonsList<WSS4JAttachment> iCommonsList) {
        this.putIn(KEY_ORIGINAL_ATTACHMENT_LIST, iCommonsList);
    }

    @Override
    @Nullable
    public ICommonsList<WSS4JAttachment> getOriginalAttachments() {
        return (ICommonsList)this.getCastedValue(KEY_ORIGINAL_ATTACHMENT_LIST);
    }

    public void setDecryptedSOAPDocument(@Nullable Document document) {
        this.putIn(KEY_DECRYPTED_SOAP_DOCUMENT, document);
    }

    @Override
    @Nullable
    public Document getDecryptedSOAPDocument() {
        return (Document)this.getCastedValue(KEY_DECRYPTED_SOAP_DOCUMENT);
    }

    public void setDecryptedAttachments(@Nullable ICommonsList<WSS4JAttachment> iCommonsList) {
        this.putIn(KEY_DECRYPTED_ATTACHMENT_LIST, iCommonsList);
    }

    @Override
    @Nullable
    public ICommonsList<WSS4JAttachment> getDecryptedAttachments() {
        return (ICommonsList)this.getCastedValue(KEY_DECRYPTED_ATTACHMENT_LIST);
    }

    public void setCompressedAttachmentIDs(@Nullable ICommonsMap<String, EAS4CompressionMode> iCommonsMap) {
        this.putIn(KEY_COMPRESSED_ATTACHMENT_IDS, iCommonsMap);
    }

    @Override
    @Nullable
    public ICommonsMap<String, EAS4CompressionMode> getCompressedAttachmentIDs() {
        return (ICommonsMap)this.getCastedValue(KEY_COMPRESSED_ATTACHMENT_IDS);
    }

    public void setMPC(@Nullable IMPC iMPC) {
        this.putIn(KEY_MPC, iMPC);
    }

    @Override
    @Nullable
    public IMPC getMPC() {
        return (IMPC)this.getCastedValue(KEY_MPC);
    }

    public void setSoapBodyPayloadPresent(boolean bl) {
        this.putIn(KEY_SOAP_BODY_PAYLOAD_PRESENT, bl);
    }

    @Override
    public boolean isSoapBodyPayloadPresent() {
        return this.getAsBoolean(KEY_SOAP_BODY_PAYLOAD_PRESENT, false);
    }

    public void setInitiatorID(@Nullable String string) {
        this.putIn(KEY_INITIATOR_ID, string);
    }

    @Override
    @Nullable
    public String getInitiatorID() {
        return this.getAsString(KEY_INITIATOR_ID);
    }

    public void setResponderID(@Nullable String string) {
        this.putIn(KEY_RESPONDER_ID, string);
    }

    @Override
    @Nullable
    public String getResponderID() {
        return this.getAsString(KEY_RESPONDER_ID);
    }

    public void setUsedCertificate(@Nullable X509Certificate x509Certificate) {
        this.putIn(KEY_USED_CERTIFICATE, x509Certificate);
    }

    @Override
    @Nullable
    public X509Certificate getUsedCertificate() {
        return (X509Certificate)this.getCastedValue(KEY_USED_CERTIFICATE);
    }

    public void setEffectivePModeLeg(@Nonnegative int n, @Nullable PModeLeg pModeLeg) {
        ValueEnforcer.isTrue((n == 1 || n == 2 ? 1 : 0) != 0, (String)"LegNumber must be 1 or 2");
        this.putIn(KEY_EFFECTIVE_PMODE_LEG, pModeLeg);
        this.putIn(KEY_EFFECTIVE_PMODE_LEG_NUMBER, n);
    }

    @Override
    @Nullable
    public PModeLeg getEffectivePModeLeg() {
        return (PModeLeg)this.getCastedValue(KEY_EFFECTIVE_PMODE_LEG);
    }

    @Override
    @CheckForSigned
    public int getEffectivePModeLegNumber() {
        return this.getAsInt(KEY_EFFECTIVE_PMODE_LEG_NUMBER, -1);
    }

    public void setSoapSignatureChecked(boolean bl) {
        this.putIn(KEY_SOAP_CHECKED_SIGNATURE, bl);
    }

    @Override
    public boolean isSoapSignatureChecked() {
        return this.getAsBoolean(KEY_SOAP_CHECKED_SIGNATURE, false);
    }

    public void setSoapDecrypted(boolean bl) {
        this.putIn(KEY_SOAP_DECRYPTED, bl);
    }

    @Override
    public boolean isSoapDecrypted() {
        return this.getAsBoolean(KEY_SOAP_DECRYPTED, false);
    }
}

