/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet;

import com.helger.as4.mgr.MetaAS4Manager;
import com.helger.as4.servlet.mgr.AS4DuplicateCleanupJob;
import com.helger.as4.servlet.mgr.AS4ServerConfiguration;
import com.helger.as4.servlet.soap.SOAPHeaderElementProcessorExtractEbms3Messaging;
import com.helger.as4.servlet.soap.SOAPHeaderElementProcessorRegistry;
import com.helger.as4.servlet.soap.SOAPHeaderElementProcessorWSS4J;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.QName;

@Immutable
public final class AS4ServerInitializer {
    private static final QName QNAME_MESSAGING = new QName("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "Messaging");
    private static final QName QNAME_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");

    private AS4ServerInitializer() {
    }

    public static void initAS4Server() {
        SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry = SOAPHeaderElementProcessorRegistry.getInstance();
        if (!sOAPHeaderElementProcessorRegistry.containsHeaderElementProcessor(QNAME_MESSAGING)) {
            sOAPHeaderElementProcessorRegistry.registerHeaderElementProcessor(QNAME_MESSAGING, new SOAPHeaderElementProcessorExtractEbms3Messaging());
        }
        if (!sOAPHeaderElementProcessorRegistry.containsHeaderElementProcessor(QNAME_SECURITY)) {
            sOAPHeaderElementProcessorRegistry.registerHeaderElementProcessor(QNAME_SECURITY, new SOAPHeaderElementProcessorWSS4J());
        }
        MetaAS4Manager.getInstance();
        AS4DuplicateCleanupJob.scheduleMe(AS4ServerConfiguration.getIncomingDuplicateDisposalMinutes());
    }
}

