/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet;

import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AS4WorkerPool
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4WorkerPool.class);
    private final ExecutorService m_aES = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, (ThreadFactory)new BasicThreadFactory.Builder().setDaemon(true).setNamingPattern("as4-worker-%d").build());

    @Deprecated
    @UsedViaReflection
    public AS4WorkerPool() {
    }

    @Nonnull
    public static AS4WorkerPool getInstance() {
        return (AS4WorkerPool)AS4WorkerPool.getGlobalSingleton(AS4WorkerPool.class);
    }

    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
        LOGGER.info("Global AS4 worker queue about to be closed");
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)this.m_aES);
        LOGGER.info("Global AS4 worker queue closed!");
    }

    @Nonnull
    public CompletableFuture<Void> run(@Nonnull IThrowingRunnable<? extends Throwable> iThrowingRunnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                iThrowingRunnable.run();
            }
            catch (Throwable throwable) {
                LOGGER.error("Error running AS4 runner " + iThrowingRunnable, throwable);
            }
        }, this.m_aES);
    }

    @Nonnull
    public <T> CompletableFuture<T> supply(@Nonnull Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                LOGGER.error("Error running AS4 supplier " + supplier, (Throwable)exception);
                return null;
            }
        }, this.m_aES);
    }
}

