/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet;

import com.helger.as4.servlet.AS4Handler;
import com.helger.as4.servlet.AS4Response;
import com.helger.as4.servlet.BadRequestException;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.lang.GenericReflection;
import com.helger.http.EHttpVersion;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public final class AS4XServletHandler
implements IXServletSimpleHandler {
    @Nonnull
    public AS4Response createUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScope iRequestWebScope) {
        return new AS4Response(eHttpVersion, eHttpMethod, httpServletRequest);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        AS4Response aS4Response = (AS4Response)((Object)GenericReflection.uncheckedCast((Object)unifiedResponse));
        try (AS4Handler aS4Handler = new AS4Handler();){
            aS4Handler.handleRequest(iRequestWebScopeWithoutResponse, aS4Response);
        }
        catch (BadRequestException badRequestException) {
            aS4Response.setResponseError(400, "Bad Request: " + badRequestException.getMessage(), badRequestException.getCause());
        }
        catch (Throwable throwable) {
            aS4Response.setResponseError(500, "Internal error processing AS4 request", throwable);
        }
    }
}

