/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet;

import com.helger.as4.attachment.EAS4CompressionMode;
import com.helger.as4.attachment.WSS4JAttachment;
import com.helger.as4.model.mpc.IMPC;
import com.helger.as4.model.pmode.IPMode;
import com.helger.as4.model.pmode.leg.PModeLeg;
import com.helger.as4.soap.ESOAPVersion;
import com.helger.as4.util.AS4ResourceManager;
import com.helger.as4lib.ebms3header.Ebms3MessageInfo;
import com.helger.as4lib.ebms3header.Ebms3Messaging;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Document;

public interface IAS4MessageState
extends IAttributeContainer<String, Object> {
    @Nonnull
    public LocalDateTime getReceiptDT();

    @Nonnull
    public ESOAPVersion getSOAPVersion();

    @Nonnull
    public AS4ResourceManager getResourceMgr();

    @Nullable
    public Ebms3Messaging getMessaging();

    @Nullable
    default public String getRefToMessageID() {
        Ebms3MessageInfo ebms3MessageInfo = null;
        Ebms3Messaging ebms3Messaging = this.getMessaging();
        if (ebms3Messaging != null) {
            if (ebms3Messaging.hasUserMessageEntries()) {
                ebms3MessageInfo = ebms3Messaging.getUserMessageAtIndex(0).getMessageInfo();
            } else if (ebms3Messaging.hasSignalMessageEntries()) {
                ebms3MessageInfo = ebms3Messaging.getSignalMessageAtIndex(0).getMessageInfo();
            }
        }
        return ebms3MessageInfo != null ? ebms3MessageInfo.getMessageId() : "";
    }

    @Nullable
    public IPMode getPMode();

    @Nullable
    public ICommonsList<WSS4JAttachment> getOriginalAttachments();

    default public boolean hasOriginalAttachments() {
        ICommonsList<WSS4JAttachment> iCommonsList = this.getOriginalAttachments();
        return iCommonsList != null && iCommonsList.isNotEmpty();
    }

    @Nullable
    public Document getDecryptedSOAPDocument();

    default public boolean hasDecryptedSOAPDocument() {
        return this.getDecryptedSOAPDocument() != null;
    }

    @Nullable
    public ICommonsList<WSS4JAttachment> getDecryptedAttachments();

    default public boolean hasDecryptedAttachments() {
        ICommonsList<WSS4JAttachment> iCommonsList = this.getDecryptedAttachments();
        return iCommonsList != null && iCommonsList.isNotEmpty();
    }

    @Nullable
    public ICommonsMap<String, EAS4CompressionMode> getCompressedAttachmentIDs();

    default public boolean hasCompressedAttachmentIDs() {
        return this.getCompressedAttachmentIDs() != null;
    }

    @Nullable
    default public EAS4CompressionMode getAttachmentCompressionMode(@Nullable String string) {
        ICommonsMap<String, EAS4CompressionMode> iCommonsMap = this.getCompressedAttachmentIDs();
        return iCommonsMap == null ? null : (EAS4CompressionMode)iCommonsMap.get((Object)string);
    }

    default public boolean containsCompressedAttachmentID(@Nullable String string) {
        ICommonsMap<String, EAS4CompressionMode> iCommonsMap = this.getCompressedAttachmentIDs();
        return iCommonsMap != null && iCommonsMap.containsKey((Object)string);
    }

    @Nullable
    public IMPC getMPC();

    public boolean isSoapBodyPayloadPresent();

    @Nullable
    public String getInitiatorID();

    @Nullable
    public String getResponderID();

    @Nullable
    public X509Certificate getUsedCertificate();

    @Nullable
    public PModeLeg getEffectivePModeLeg();

    @CheckForSigned
    public int getEffectivePModeLegNumber();

    public boolean isSoapSignatureChecked();

    public boolean isSoapDecrypted();
}

