/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.mgr;

import com.helger.as4.mgr.MetaAS4Manager;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.lang.ClassHelper;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class AS4DuplicateCleanupJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4DuplicateCleanupJob.class);
    private static final String KEY_MINUTES = "mins";
    private static final AtomicBoolean s_aScheduled = new AtomicBoolean(false);

    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        long l = jobDataMap.getAsLong((Object)KEY_MINUTES);
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime().minusMinutes(l);
        ICommonsList iCommonsList = MetaAS4Manager.getIncomingDuplicateMgr().evictAllItemsBefore(localDateTime);
        if (iCommonsList.isNotEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evicted " + iCommonsList.size() + " incoming duplicate message IDs before " + localDateTime.toString());
        }
    }

    public static void scheduleMe(long l) {
        if (l > 0L) {
            if (!s_aScheduled.getAndSet(true)) {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.putIn((Object)KEY_MINUTES, l);
                GlobalQuartzScheduler.getInstance().scheduleJob(ClassHelper.getClassLocalName(AS4DuplicateCleanupJob.class) + "-" + l, JDK8TriggerBuilder.newTrigger().startNow().withSchedule((IScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever((int)5)), AS4DuplicateCleanupJob.class, (Map)jobDataMap);
            }
        } else {
            LOGGER.warn("Incoming duplicate message cleaning is disabled!");
        }
    }
}

