/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.mgr;

import com.helger.commons.exception.InitializationException;
import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class AS4ServerConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ServerConfiguration.class);
    private static final Settings SETTINGS = new Settings("as4-server");
    private static boolean s_bUnitTestMode = false;
    private static final long DEFAULT_RESET_MINUTES = 10L;

    public static void reinit(boolean bl) {
        s_bUnitTestMode = bl;
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder();
        if (bl) {
            configFileBuilder.addPathFromEnvVar("AS4_SERVER_TEST_CONFIG").addPathFromSystemProperty("as4.server.test.configfile").addPath("private-test-as4.properties").addPath("test-as4.properties");
        } else {
            configFileBuilder.addPathFromEnvVar("AS4_SERVER_CONFIG").addPathFromSystemProperty("as4.server.configfile").addPath("private-as4.properties").addPath("as4.properties");
        }
        ConfigFile configFile = configFileBuilder.build();
        if (!configFile.isRead()) {
            throw new InitializationException("Failed to read AS4 server configuration file!");
        }
        LOGGER.info("Successfully read AS4 configuration file from " + configFile.getReadResource().getPath());
        SETTINGS.setAll((Map)configFile.getSettings());
    }

    public static void internalReinitForTestOnly() {
        if (!s_bUnitTestMode) {
            AS4ServerConfiguration.reinit(true);
        }
    }

    private AS4ServerConfiguration() {
    }

    @Nonnull
    public static ISettings getSettings() {
        return SETTINGS;
    }

    @Nonnull
    public static Settings getMutableSettings() {
        return SETTINGS;
    }

    @Nullable
    public static String getAS4ProfileID() {
        return AS4ServerConfiguration.getSettings().getAsString((Object)"server.profile");
    }

    @Nonnull
    public static boolean isGlobalDebug() {
        return AS4ServerConfiguration.getSettings().getAsBoolean((Object)"server.debug", true);
    }

    @Nonnull
    public static boolean isGlobalProduction() {
        return AS4ServerConfiguration.getSettings().getAsBoolean((Object)"server.production", false);
    }

    @Nonnull
    public static boolean isNoStartupInfo() {
        return AS4ServerConfiguration.getSettings().getAsBoolean((Object)"server.nostartupinfo", false);
    }

    @Nonnull
    public static String getDataPath() {
        return AS4ServerConfiguration.getSettings().getAsString((Object)"server.datapath", "conf");
    }

    public static long getIncomingDuplicateDisposalMinutes() {
        return AS4ServerConfiguration.getSettings().getAsLong((Object)"server.incoming.duplicatedisposal.minutes", 10L);
    }

    @Nullable
    public static String getServerAddress() {
        return AS4ServerConfiguration.getSettings().getAsString((Object)"server.address");
    }

    static {
        AS4ServerConfiguration.reinit(false);
    }
}

