/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.mgr;

import com.helger.as4.attachment.IIncomingAttachmentFactory;
import com.helger.as4.attachment.WSS4JAttachment;
import com.helger.as4.crypto.AS4CryptoFactory;
import com.helger.as4.model.pmode.resolve.DefaultPModeResolver;
import com.helger.as4.model.pmode.resolve.IPModeResolver;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AS4ServerSettings {
    private static final String DEFAULT_RESPONDER_ID = "default";
    private static String s_sResponderID = "default";
    private static IIncomingAttachmentFactory s_aIncomingAttachmentFactory = WSS4JAttachment::createIncomingFileAttachment;
    private static IPModeResolver s_aPModeResolver = new DefaultPModeResolver(false);
    private static AS4CryptoFactory s_aAS4CryptoFactory = AS4CryptoFactory.DEFAULT_INSTANCE;

    private AS4ServerSettings() {
    }

    @Nonnull
    @Nonempty
    public static String getDefaultResponderID() {
        return s_sResponderID;
    }

    public static void setDefaultResponderID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ResponderID");
        s_sResponderID = string;
    }

    @Nonnull
    public static IIncomingAttachmentFactory getIncomingAttachmentFactory() {
        return s_aIncomingAttachmentFactory;
    }

    public static void setIncomingAttachmentFactory(@Nonnull IIncomingAttachmentFactory iIncomingAttachmentFactory) {
        ValueEnforcer.notNull((Object)iIncomingAttachmentFactory, (String)"IncomingAttachmentFactory");
        s_aIncomingAttachmentFactory = iIncomingAttachmentFactory;
    }

    @Nonnull
    public static IPModeResolver getPModeResolver() {
        return s_aPModeResolver;
    }

    public static void setPModeResolver(@Nonnull IPModeResolver iPModeResolver) {
        ValueEnforcer.notNull((Object)iPModeResolver, (String)"PModeResolver");
        s_aPModeResolver = iPModeResolver;
    }

    @Nonnull
    public static AS4CryptoFactory getAS4CryptoFactory() {
        return s_aAS4CryptoFactory;
    }

    public static void setAS4CryptoFactory(@Nonnull AS4CryptoFactory aS4CryptoFactory) {
        ValueEnforcer.notNull((Object)aS4CryptoFactory, (String)"AS4CryptoFactory");
        s_aAS4CryptoFactory = aS4CryptoFactory;
    }
}

