/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.soap;

import com.helger.as4.crypto.CryptoProperties;
import com.helger.as4.servlet.mgr.AS4ServerSettings;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KeyStoreCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreCallbackHandler.class);

    KeyStoreCallbackHandler() {
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        CryptoProperties cryptoProperties = AS4ServerSettings.getAS4CryptoFactory().getCryptoProperties();
        for (Callback callback : callbackArray) {
            if (callback instanceof WSPasswordCallback) {
                WSPasswordCallback wSPasswordCallback = (WSPasswordCallback)callback;
                if (cryptoProperties.getKeyAlias().equals(wSPasswordCallback.getIdentifier())) {
                    wSPasswordCallback.setPassword(cryptoProperties.getKeyPassword());
                    LOGGER.info("Found keystore password for alias '" + wSPasswordCallback.getIdentifier() + "'");
                    continue;
                }
                LOGGER.warn("Found unsupported keystore alias '" + wSPasswordCallback.getIdentifier() + "'");
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }
}

