/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.soap;

import com.helger.as4.attachment.EAS4CompressionMode;
import com.helger.as4.attachment.WSS4JAttachment;
import com.helger.as4.error.EEbmsError;
import com.helger.as4.marshaller.Ebms3ReaderBuilder;
import com.helger.as4.mgr.MetaAS4Manager;
import com.helger.as4.model.mpc.IMPC;
import com.helger.as4.model.mpc.MPCManager;
import com.helger.as4.model.pmode.IPMode;
import com.helger.as4.model.pmode.PMode;
import com.helger.as4.model.pmode.leg.PModeLeg;
import com.helger.as4.servlet.AS4MessageState;
import com.helger.as4.servlet.mgr.AS4ServerConfiguration;
import com.helger.as4.servlet.mgr.AS4ServerSettings;
import com.helger.as4.servlet.mgr.AS4ServletPullRequestProcessorManager;
import com.helger.as4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.as4.servlet.spi.IAS4ServletPullRequestProcessorSPI;
import com.helger.as4lib.ebms3header.Ebms3CollaborationInfo;
import com.helger.as4lib.ebms3header.Ebms3Error;
import com.helger.as4lib.ebms3header.Ebms3Messaging;
import com.helger.as4lib.ebms3header.Ebms3PartyId;
import com.helger.as4lib.ebms3header.Ebms3PayloadInfo;
import com.helger.as4lib.ebms3header.Ebms3Property;
import com.helger.as4lib.ebms3header.Ebms3PullRequest;
import com.helger.as4lib.ebms3header.Ebms3Receipt;
import com.helger.as4lib.ebms3header.Ebms3SignalMessage;
import com.helger.as4lib.ebms3header.Ebms3UserMessage;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.jaxb.validation.CollectingValidationEventHandler;
import com.helger.xml.XMLHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SOAPHeaderElementProcessorExtractEbms3Messaging
implements ISOAPHeaderElementProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorExtractEbms3Messaging.class);

    private static boolean _isUseLeg1(@Nonnull Ebms3UserMessage ebms3UserMessage) {
        String string = ebms3UserMessage.getMessageInfo().getMessageId();
        String string2 = ebms3UserMessage.getMessageInfo().getRefToMessageId();
        if (StringHelper.hasText((String)string2) && string.equals(string2)) {
            LOGGER.warn("MessageID and ReferenceToMessageID are the same!");
        }
        return StringHelper.hasNoText((String)string2) || string2.equals(string);
    }

    @Nullable
    private static String _getMPCIDOfUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PModeLeg pModeLeg) {
        String string = ebms3UserMessage.getMpc();
        if (string == null && pModeLeg.getBusinessInfo() != null) {
            string = pModeLeg.getBusinessInfo().getMPCID();
        }
        return string;
    }

    @Nonnull
    private static ESuccess _checkMPCOfPMode(@Nonnull PModeLeg pModeLeg, @Nonnull MPCManager mPCManager, @Nonnull Locale locale, @Nonnull ErrorList errorList) {
        String string;
        if (pModeLeg.getBusinessInfo() != null && (string = pModeLeg.getBusinessInfo().getMPCID()) != null && !mPCManager.containsWithID(string)) {
            LOGGER.warn("Error processing the usermessage, PMode-MPC ID '" + string + "' is invalid!");
            errorList.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    private static boolean _checkSOAPBodyHasPayload(@Nonnull PModeLeg pModeLeg, @Nonnull Document document) {
        Element element = XMLHelper.getFirstChildElementOfName((Node)document.getFirstChild(), (String)pModeLeg.getProtocol().getSOAPVersion().getBodyElementName());
        return element != null && element.hasChildNodes();
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        MPCManager mPCManager = MetaAS4Manager.getMPCMgr();
        PMode pMode = null;
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        IMPC iMPC = null;
        String string = null;
        String string2 = null;
        CollectingValidationEventHandler collectingValidationEventHandler = new CollectingValidationEventHandler();
        Ebms3Messaging ebms3Messaging = (Ebms3Messaging)((Ebms3ReaderBuilder)Ebms3ReaderBuilder.ebms3Messaging().setValidationEventHandler((ValidationEventHandler)collectingValidationEventHandler)).read((Node)element);
        if (ebms3Messaging == null) {
            for (IError iError : collectingValidationEventHandler.getErrorList()) {
                errorList.add((Object)((SingleError.SingleErrorBuilder)SingleError.builder((IError)iError).setErrorID(EEbmsError.EBMS_INVALID_HEADER.getErrorCode())).build());
            }
            return ESuccess.FAILURE;
        }
        aS4MessageState.setMessaging(ebms3Messaging);
        int n = ebms3Messaging.getUserMessageCount();
        if (n > 1) {
            LOGGER.warn("Too many UserMessage objects contained: " + n);
            errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
            return ESuccess.FAILURE;
        }
        int n2 = ebms3Messaging.getSignalMessageCount();
        if (n2 > 1) {
            LOGGER.warn("Too many SignalMessage objects contained: " + n2);
            errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
            return ESuccess.FAILURE;
        }
        if (n + n2 == 0) {
            LOGGER.warn("Neither UserMessage nor SignalMessage object contained!");
            errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
            return ESuccess.FAILURE;
        }
        Ebms3UserMessage ebms3UserMessage = (Ebms3UserMessage)CollectionHelper.getAtIndex((List)ebms3Messaging.getUserMessage(), (int)0);
        if (ebms3UserMessage != null) {
            String string3;
            String string4;
            List list = ebms3UserMessage.getPartyInfo().getFrom().getPartyId();
            List list2 = ebms3UserMessage.getPartyInfo().getTo().getPartyId();
            if (list.size() > 1 || list2.size() > 1) {
                LOGGER.warn("More than one partyId is containted in From or To Recipient please check the message.");
                errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                return ESuccess.FAILURE;
            }
            string = ((Ebms3PartyId)list.get(0)).getValue();
            string2 = ((Ebms3PartyId)list2.get(0)).getValue();
            Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
            if (ebms3CollaborationInfo != null) {
                string4 = null;
                if (ebms3CollaborationInfo.getAgreementRef() != null) {
                    string4 = ebms3CollaborationInfo.getAgreementRef().getPmode();
                }
                string3 = AS4ServerConfiguration.getServerAddress();
                pMode = AS4ServerSettings.getPModeResolver().getPModeOfID(string4, ebms3CollaborationInfo.getService().getValue(), ebms3CollaborationInfo.getAction(), string, string2, string3);
                if (pMode == null) {
                    LOGGER.warn("Failed to resolve PMode '" + string4 + "' using resolver " + AS4ServerSettings.getPModeResolver());
                    errorList.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
            string4 = null;
            string3 = null;
            boolean bl = false;
            if (pMode != null) {
                int n3;
                string4 = pMode.getLeg1();
                string3 = pMode.getLeg2();
                if (pMode.getMEPBinding().getRequiredLegs() == 2 && string3 == null) {
                    LOGGER.warn("Error processing the usermessage, PMode does not contain leg 2!");
                    errorList.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                boolean bl2 = SOAPHeaderElementProcessorExtractEbms3Messaging._isUseLeg1(ebms3UserMessage);
                String string5 = bl2 ? string4 : string3;
                int n4 = n3 = bl2 ? 1 : 2;
                if (string5 == null) {
                    LOGGER.warn("Error processing the usermessage, PMode does not contain effective leg " + n3 + "!");
                    errorList.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                aS4MessageState.setEffectivePModeLeg(n3, (PModeLeg)string5);
                if (SOAPHeaderElementProcessorExtractEbms3Messaging._checkMPCOfPMode((PModeLeg)string5, mPCManager, locale, errorList).isFailure()) {
                    return ESuccess.FAILURE;
                }
                bl = SOAPHeaderElementProcessorExtractEbms3Messaging._checkSOAPBodyHasPayload((PModeLeg)string5, document);
                Object object = SOAPHeaderElementProcessorExtractEbms3Messaging._getMPCIDOfUserMsg(ebms3UserMessage, (PModeLeg)string5);
                iMPC = mPCManager.getMPCOrDefaultOfID((String)object);
                if (iMPC == null) {
                    LOGGER.warn("Error processing the usermessage, effective usermessage MPC ID '" + (String)object + "' is unknown!");
                    errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
            aS4MessageState.setSoapBodyPayloadPresent(bl);
            Ebms3PayloadInfo ebms3PayloadInfo = ebms3UserMessage.getPayloadInfo();
            if (ebms3PayloadInfo == null || ebms3PayloadInfo.getPartInfo().isEmpty()) {
                if (bl) {
                    LOGGER.warn("No PartInfo is specified, so no SOAPBodyPayload is allowed.");
                    errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (iCommonsList.isNotEmpty()) {
                    LOGGER.warn("No PartInfo is specified, so no attachments are allowed.");
                    errorList.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            } else {
                if (iCommonsList.size() > ebms3PayloadInfo.getPartInfoCount()) {
                    LOGGER.warn("Error processing the UserMessage, the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected '" + ebms3PayloadInfo.getPartInfoCount() + "' but was '" + iCommonsList.size() + "'");
                    errorList.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                int n5 = 0;
                for (Object object : ebms3PayloadInfo.getPartInfo()) {
                    if (StringHelper.hasNoText((String)object.getHref())) {
                        if (bl) continue;
                        LOGGER.warn("Error processing the UserMessage, Expected a BodyPayload but there is none present. ");
                        errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    ++n5;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (object.getPartProperties() != null) {
                        for (Ebms3Property ebms3Property : object.getPartProperties().getProperty()) {
                            if (ebms3Property.getName().equalsIgnoreCase("mimetype")) {
                                bl3 = true;
                            }
                            if (!ebms3Property.getName().equalsIgnoreCase("compressiontype")) continue;
                            EAS4CompressionMode eAS4CompressionMode = EAS4CompressionMode.getFromMimeTypeStringOrNull((String)ebms3Property.getValue());
                            if (eAS4CompressionMode == null) {
                                LOGGER.warn("Error processing the UserMessage, CompressionType " + ebms3Property.getValue() + " is not supported. ");
                                errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                                return ESuccess.FAILURE;
                            }
                            String string6 = StringHelper.trimStart((String)object.getHref(), (String)"cid:");
                            commonsHashMap.put((Object)string6, (Object)eAS4CompressionMode);
                            bl4 = true;
                        }
                    }
                    if (bl3 || !bl4) continue;
                    LOGGER.warn("Error processing the UserMessage, MimeType for a compressed message not present. ");
                    errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (n5 != iCommonsList.size()) {
                    LOGGER.warn("Error processing the UserMessage, the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected '" + ebms3PayloadInfo.getPartInfoCount() + "' but was '" + iCommonsList.size() + "'");
                    errorList.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
        } else {
            Ebms3SignalMessage ebms3SignalMessage = ebms3Messaging.getSignalMessageAtIndex(0);
            Ebms3PullRequest ebms3PullRequest = ebms3SignalMessage.getPullRequest();
            Ebms3Receipt ebms3Receipt = ebms3SignalMessage.getReceipt();
            if (ebms3PullRequest != null) {
                IMPC iMPC2 = mPCManager.getMPCOfID(ebms3PullRequest.getMpc());
                if (iMPC2 == null) {
                    errorList.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                for (IAS4ServletPullRequestProcessorSPI iAS4ServletPullRequestProcessorSPI : AS4ServletPullRequestProcessorManager.getAllProcessors()) {
                    pMode = iAS4ServletPullRequestProcessorSPI.processAS4UserMessage(ebms3SignalMessage);
                    if (pMode == null) continue;
                    LOGGER.info("Found P-Mode " + (String)pMode.getID() + " for signal message " + ebms3SignalMessage);
                    break;
                }
                if (pMode == null) {
                    errorList.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            } else if (ebms3Receipt != null) {
                if (StringHelper.hasNoText((String)ebms3SignalMessage.getMessageInfo().getRefToMessageId())) {
                    errorList.add((Object)EEbmsError.EBMS_INVALID_RECEIPT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            } else if (!ebms3SignalMessage.getError().isEmpty()) {
                for (Ebms3Error ebms3Error : ebms3SignalMessage.getError()) {
                    if (!StringHelper.hasNoText((String)ebms3Error.getRefToMessageInError())) continue;
                    errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
        }
        aS4MessageState.setPMode((IPMode)pMode);
        aS4MessageState.setOriginalAttachments(iCommonsList);
        aS4MessageState.setCompressedAttachmentIDs((ICommonsMap<String, EAS4CompressionMode>)commonsHashMap);
        aS4MessageState.setMPC(iMPC);
        aS4MessageState.setInitiatorID(string);
        aS4MessageState.setResponderID(string2);
        return ESuccess.SUCCESS;
    }
}

