/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.soap;

import com.helger.as4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SOAPHeaderElementProcessorRegistry
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorRegistry.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedMap<QName, ISOAPHeaderElementProcessor> m_aMap = new CommonsLinkedHashMap();

    @Deprecated
    @UsedViaReflection
    public SOAPHeaderElementProcessorRegistry() {
    }

    @Nonnull
    public static SOAPHeaderElementProcessorRegistry getInstance() {
        return (SOAPHeaderElementProcessorRegistry)SOAPHeaderElementProcessorRegistry.getGlobalSingleton(SOAPHeaderElementProcessorRegistry.class);
    }

    public void registerHeaderElementProcessor(@Nonnull QName qName, @Nonnull ISOAPHeaderElementProcessor iSOAPHeaderElementProcessor) {
        ValueEnforcer.notNull((Object)qName, (String)"QName");
        ValueEnforcer.notNull((Object)iSOAPHeaderElementProcessor, (String)"Processor");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)qName)) {
                throw new IllegalArgumentException("A processor for QName " + qName.toString() + " is already registered!");
            }
            this.m_aMap.put((Object)qName, (Object)iSOAPHeaderElementProcessor);
        });
        LOGGER.info("Successfully registered SOAP header element processor for " + qName.toString());
    }

    @Nullable
    public ISOAPHeaderElementProcessor getHeaderElementProcessor(@Nullable QName qName) {
        if (qName == null) {
            return null;
        }
        return (ISOAPHeaderElementProcessor)this.m_aRWLock.readLocked(() -> (ISOAPHeaderElementProcessor)this.m_aMap.get((Object)qName));
    }

    public boolean containsHeaderElementProcessor(@Nullable QName qName) {
        return qName != null && this.m_aRWLock.readLocked(() -> this.m_aMap.containsKey((Object)qName));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<QName, ISOAPHeaderElementProcessor> getAllElementProcessors() {
        return (ICommonsOrderedMap)this.m_aRWLock.readLocked(() -> this.m_aMap.getClone());
    }
}

