/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.soap;

import com.helger.as4.attachment.WSS4JAttachment;
import com.helger.as4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.as4.crypto.ECryptoAlgorithmSign;
import com.helger.as4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.as4.error.EEbmsError;
import com.helger.as4.model.pmode.IPMode;
import com.helger.as4.model.pmode.leg.PModeLeg;
import com.helger.as4.servlet.AS4MessageState;
import com.helger.as4.servlet.mgr.AS4ServerSettings;
import com.helger.as4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.as4.servlet.soap.KeyStoreCallbackHandler;
import com.helger.as4lib.ebms3header.Ebms3Messaging;
import com.helger.as4lib.ebms3header.Ebms3UserMessage;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.xml.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPHeaderElementProcessorWSS4J
implements ISOAPHeaderElementProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorWSS4J.class);

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ErrorList errorList, @Nonnull Locale locale) {
        IPMode iPMode = aS4MessageState.getPMode();
        if (iPMode == null) {
            throw new IllegalStateException("No PMode contained in AS4 state - seems like Ebms3 Messaging header is missing!");
        }
        PModeLeg pModeLeg = iPMode.getLeg1();
        Ebms3Messaging ebms3Messaging = aS4MessageState.getMessaging();
        Ebms3UserMessage ebms3UserMessage = null;
        if (ebms3Messaging != null && ebms3Messaging.hasUserMessageEntries() && (ebms3UserMessage = ebms3Messaging.getUserMessageAtIndex(0)) != null && StringHelper.hasText((String)ebms3UserMessage.getMessageInfo().getRefToMessageId())) {
            pModeLeg = iPMode.getLeg2();
        }
        if (pModeLeg.getSecurity() != null) {
            Object object;
            Object object2;
            Object object3;
            Element element2 = XMLHelper.getFirstChildElementOfName((Node)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
            if (element2 != null) {
                object3 = XMLHelper.getFirstChildElementOfName((Node)(element2 = XMLHelper.getFirstChildElementOfName((Node)element2, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignedInfo")), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignatureMethod");
                String string = object3 == null ? null : object3.getAttribute("Algorithm");
                object2 = ECryptoAlgorithmSign.getFromURIOrNull((String)string);
                if (object2 == null) {
                    LOGGER.info("Error processing the Security Header, your signing algorithm '" + string + "' is incorrect. Expected one of the following '" + Arrays.asList(ECryptoAlgorithmSign.values()) + "' algorithms");
                    errorList.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature algorithm " + object2);
                }
                element2 = XMLHelper.getFirstChildElementOfName((Node)element2, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Reference");
                string = (element2 = XMLHelper.getFirstChildElementOfName((Node)element2, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"DigestMethod")) == null ? null : element2.getAttribute("Algorithm");
                object = ECryptoAlgorithmSignDigest.getFromURIOrNull((String)string);
                if (object == null) {
                    LOGGER.info("Error processing the Security Header, your signing digest algorithm is incorrect. Expected one of the following'" + Arrays.toString(ECryptoAlgorithmSignDigest.values()) + "' algorithms");
                    errorList.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature digest algorithm " + object);
                }
            }
            if (ebms3UserMessage != null) {
                boolean bl = aS4MessageState.isSoapBodyPayloadPresent();
                for (int i = 0; i < iCommonsList.size(); ++i) {
                    object2 = (String)((WSS4JAttachment)iCommonsList.get(i)).getHeaders().get("Content-ID");
                    object2 = ((String)object2).substring("<attachment=".length(), ((String)object2).length() - 1);
                    object = ebms3UserMessage.getPayloadInfo().getPartInfoAtIndex((bl ? 1 : 0) + i).getHref();
                    if (((String)object).contains((CharSequence)object2)) continue;
                    LOGGER.info("Error processing the Attachments, the attachment '" + (String)object + "' is not valid with what is specified in the usermessage ('" + (String)object2 + "')");
                    errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
            object3 = new WSSecurityEngine();
            List list = null;
            try {
                Object object4;
                object2 = new KeyStoreCallbackHandler();
                object = new WSS4JAttachmentCallbackHandler(iCommonsList, aS4MessageState.getResourceMgr());
                RequestData requestData = new RequestData();
                requestData.setCallbackHandler((CallbackHandler)object2);
                if (iCommonsList.isNotEmpty()) {
                    requestData.setAttachmentCallbackHandler((CallbackHandler)object);
                }
                requestData.setSigVerCrypto(AS4ServerSettings.getAS4CryptoFactory().getCrypto());
                requestData.setDecCrypto(AS4ServerSettings.getAS4CryptoFactory().getCrypto());
                requestData.setWssConfig(WSSConfig.getNewInstance());
                list = object3.processSecurityHeader(document, requestData).getResults();
                CommonsHashSet commonsHashSet = new CommonsHashSet();
                for (Object object5 : list) {
                    X509Certificate x509Certificate = (X509Certificate)object5.get((Object)"x509-certificate");
                    if (x509Certificate != null) {
                        commonsHashSet.add((Object)x509Certificate);
                    }
                    if ((object4 = (Integer)object5.get((Object)"action")) == null) continue;
                    switch ((Integer)object4) {
                        case 2: {
                            aS4MessageState.setSoapSignatureChecked(true);
                            break;
                        }
                        case 4: {
                            aS4MessageState.setSoapDecrypted(true);
                        }
                    }
                }
                if (commonsHashSet.size() > 1) {
                    if (GlobalDebug.isDebugMode()) {
                        LOGGER.warn("Found " + commonsHashSet.size() + " different certificates in message: " + commonsHashSet);
                    } else {
                        LOGGER.warn("Found " + commonsHashSet.size() + " different certificates in message!");
                    }
                }
                aS4MessageState.setUsedCertificate((X509Certificate)commonsHashSet.getAtIndex(0));
                aS4MessageState.setDecryptedSOAPDocument(document);
                ICommonsList iCommonsList2 = object.getAllResponseAttachments();
                for (X509Certificate x509Certificate : iCommonsList2) {
                    object4 = x509Certificate.getSourceStream();
                    File file = aS4MessageState.getResourceMgr().createTempFile();
                    StreamHelper.copyInputStreamToOutputStreamAndCloseOS((InputStream)object4, (OutputStream)FileHelper.getBufferedOutputStream((File)file));
                    x509Certificate.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple((ISupplier & Serializable)() -> FileHelper.getBufferedInputStream((File)file)));
                }
                aS4MessageState.setDecryptedAttachments((ICommonsList<WSS4JAttachment>)iCommonsList2);
            }
            catch (IOException | WSSecurityException throwable) {
                LOGGER.info("Error processing the WSSSecurity Header", throwable);
                errorList.add((Object)EEbmsError.EBMS_FAILED_DECRYPTION.getAsError(locale));
                return ESuccess.FAILURE;
            }
        }
        return ESuccess.SUCCESS;
    }
}

