/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as4.servlet.spi;

import com.helger.as4.attachment.WSS4JAttachment;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS4MessageProcessorResult
implements ISuccessIndicator {
    private final ESuccess m_eSuccess;
    private final String m_sErrorMsg;
    private final ICommonsList<WSS4JAttachment> m_aAttachments;
    private final String m_sAsyncResponseURL;

    protected AS4MessageProcessorResult(@Nonnull ESuccess eSuccess, @Nullable String string, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable String string2) {
        this.m_eSuccess = (ESuccess)ValueEnforcer.notNull((Object)eSuccess, (String)"Success");
        this.m_sErrorMsg = string;
        this.m_aAttachments = iCommonsList;
        this.m_sAsyncResponseURL = string2;
    }

    public boolean isSuccess() {
        return this.m_eSuccess.isSuccess();
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_sErrorMsg;
    }

    public boolean hasAttachments() {
        return CollectionHelper.isNotEmpty(this.m_aAttachments);
    }

    public void addAllAttachmentsTo(@Nonnull Collection<WSS4JAttachment> collection) {
        if (this.m_aAttachments != null) {
            collection.addAll((Collection<WSS4JAttachment>)this.m_aAttachments);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WSS4JAttachment> getAllAttachments() {
        return new CommonsArrayList(this.m_aAttachments);
    }

    @Nullable
    public String getAsyncResponseURL() {
        return this.m_sAsyncResponseURL;
    }

    public boolean hasAsyncResponseURL() {
        return StringHelper.hasText((String)this.m_sAsyncResponseURL);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Success", (Enum)this.m_eSuccess).appendIf("ErrorMsg", (Object)this.m_sErrorMsg, string -> this.m_eSuccess.isFailure()).appendIf("Attachments", this.m_aAttachments, iCommonsList -> this.m_eSuccess.isSuccess()).appendIfNotNull("AsyncResponseURL", (Object)this.m_sAsyncResponseURL).getToString();
    }

    @Nonnull
    public static AS4MessageProcessorResult createSuccess() {
        return AS4MessageProcessorResult.createSuccess(null, null);
    }

    @Nonnull
    public static AS4MessageProcessorResult createSuccess(@Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable String string) {
        return new AS4MessageProcessorResult(ESuccess.SUCCESS, null, iCommonsList, string);
    }

    @Nonnull
    public static AS4MessageProcessorResult createFailure(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"ErrorMsg");
        return new AS4MessageProcessorResult(ESuccess.FAILURE, string, null, null);
    }
}

